/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.clustering;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.I18nHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedHomeCheck
implements StartupCheck {
    private static final Logger LOG = LoggerFactory.getLogger(SharedHomeCheck.class);
    static final String NAME = "JIRA Cluster Shared Home Check";
    private final ClusterNodeProperties clusterNodeProperties;
    private final JiraHome jiraHome;
    private final I18nHelper i18nHelper;
    private String faultDescription;

    public SharedHomeCheck(ClusterNodeProperties clusterNodeProperties, I18nHelper i18nHelper, JiraHome jiraHome) {
        this.clusterNodeProperties = clusterNodeProperties;
        this.i18nHelper = i18nHelper;
        this.jiraHome = jiraHome;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        LOG.debug("Performing JIRA Cluster Shared Home Check");
        if (StringUtils.isBlank((CharSequence)this.clusterNodeProperties.getSharedHome())) {
            this.faultDescription = this.i18nHelper.getText("startup.shared.home.check.missing");
            return false;
        }
        File localHome = this.jiraHome.getLocalHome();
        File sharedHome = this.jiraHome.getHome();
        try {
            localHome = localHome.getCanonicalFile();
            sharedHome = sharedHome.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.error("I/O error canonicalizing home directory: " + e, (Throwable)e);
        }
        if (localHome.equals(sharedHome)) {
            LOG.error("Shared home is the same as local home (" + localHome.getPath() + ")");
            this.faultDescription = this.i18nHelper.getText("startup.shared.home.check.sameaslocal", this.jiraHome.getLocalHomePath());
            return false;
        }
        return true;
    }

    @Override
    public String getFaultDescription() {
        return this.faultDescription;
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.getFaultDescription();
    }
}

