/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NoopCacheEventListenerFactory
extends CacheEventListenerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NoopCacheEventListenerFactory.class);

    static CacheManager workAroundCache95(CacheManager ehCacheManager) {
        CacheConfiguration defaultConfig = ehCacheManager.getConfiguration().getDefaultCacheConfiguration();
        CacheConfiguration.CacheEventListenerFactoryConfiguration listenerConfig = (CacheConfiguration.CacheEventListenerFactoryConfiguration)new CacheConfiguration.CacheEventListenerFactoryConfiguration().className(NoopCacheEventListenerFactory.class.getName());
        defaultConfig.clone().addCacheEventListenerFactory(listenerConfig);
        if (defaultConfig.getCacheEventListenerConfigurations().isEmpty()) {
            LOG.warn("It looks like CACHE-95 has been fixed.  This workaround should be removed.");
        } else {
            LOG.debug("Working around CACHE-95");
        }
        return ehCacheManager;
    }

    public CacheEventListener createCacheEventListener(Properties properties) {
        return NoopCacheEventListener.INSTANCE;
    }

    static final class NoopCacheEventListener
    implements CacheEventListener {
        static final NoopCacheEventListener INSTANCE = new NoopCacheEventListener();

        NoopCacheEventListener() {
        }

        public void notifyElementRemoved(Ehcache cache, Element element) {
        }

        public void notifyElementPut(Ehcache cache, Element element) {
        }

        public void notifyElementUpdated(Ehcache cache, Element element) {
        }

        public void notifyElementExpired(Ehcache cache, Element element) {
        }

        public void notifyElementEvicted(Ehcache cache, Element element) {
        }

        public void notifyRemoveAll(Ehcache cache) {
        }

        public void dispose() {
        }

        public Object clone() {
            return this;
        }
    }
}

