/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.beehive.db.ClusterNodeHeartbeatService;
import com.atlassian.beehive.db.spi.ClusterLockDao;
import com.atlassian.beehive.db.spi.ClusterNodeHeartBeatDao;
import com.atlassian.beehive.simple.SimpleClusterLockService;
import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.MultipleKeyRegistrant;
import com.atlassian.jira.bc.dataimport.ha.ClusterImportListener;
import com.atlassian.jira.bc.dataimport.ha.ClusterImportService;
import com.atlassian.jira.bc.dataimport.ha.DefaultClusterImportService;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.ClusterNodePropertiesImpl;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.cluster.DatabaseClusterMessagingService;
import com.atlassian.jira.cluster.DefaultClusterManager;
import com.atlassian.jira.cluster.DefaultClusterNodes;
import com.atlassian.jira.cluster.DefaultClusterServicesManager;
import com.atlassian.jira.cluster.DefaultNodeStateManager;
import com.atlassian.jira.cluster.DefaultNodeStateService;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NodeStateService;
import com.atlassian.jira.cluster.OfBizClusterMessageStore;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.jira.cluster.OfBizMessageHandlerService;
import com.atlassian.jira.cluster.lock.JiraClusterLockDao;
import com.atlassian.jira.cluster.lock.JiraClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.lock.NullClusterNodeHeartbeatService;
import com.atlassian.jira.cluster.lock.NullJiraClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.lock.StartableClusterNodeHeartbeatService;
import com.atlassian.jira.cluster.lock.StartableDatabaseClusterLockService;
import com.atlassian.jira.cluster.lock.TimedClusterNodeHeartBeatDao;
import com.atlassian.jira.index.ha.DefaultIndexCopyService;
import com.atlassian.jira.index.ha.DefaultNodeReindexService;
import com.atlassian.jira.index.ha.DefaultReplicatedIndexManager;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.index.ha.NullReplicatedIndexManager;
import com.atlassian.jira.index.ha.OfBizNodeIndexCounterStore;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.index.ha.SharedEntityResolver;
import com.atlassian.jira.plugin.ha.DefaultPluginSyncService;
import com.atlassian.jira.plugin.ha.MessageEventRegistry;
import com.atlassian.jira.plugin.ha.PluginMessageSender;
import com.atlassian.jira.plugin.ha.PluginSyncService;
import com.atlassian.jira.plugin.ha.ReplicatedPluginManager;

public class ClusterServicesRegistrar {
    static void register(ComponentContainer register) {
        register.implementation(ComponentContainer.Scope.PROVIDED, ClusterNodeProperties.class, ClusterNodePropertiesImpl.class);
        MultipleKeyRegistrant.registrantFor(DefaultClusterManager.class).implementing(ClusterInfo.class).implementing(ClusterManager.class).registerWith(ComponentContainer.Scope.PROVIDED, register);
        register.implementation(ComponentContainer.Scope.INTERNAL, IndexCopyService.class, DefaultIndexCopyService.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, SharedEntityResolver.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, OfBizReplicatedIndexOperationStore.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, OfBizNodeIndexCounterStore.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, OfBizClusterMessageStore.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, NodeReindexService.class, DefaultNodeReindexService.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, IndexUtils.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, MessageHandlerService.class, OfBizMessageHandlerService.class);
        register.implementation(ComponentContainer.Scope.PROVIDED, ClusterMessagingService.class, DatabaseClusterMessagingService.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, PluginMessageSender.class);
        register.implementation(ComponentContainer.Scope.PROVIDED, ClusterServicesManager.class, DefaultClusterServicesManager.class);
        register.implementation(ComponentContainer.Scope.PROVIDED, NodeStateManager.class, DefaultNodeStateManager.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, ClusterNodes.class, DefaultClusterNodes.class);
        register.implementation(ComponentContainer.Scope.PROVIDED, NodeStateService.class, DefaultNodeStateService.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, OfBizClusterNodeStore.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, MessageEventRegistry.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, ReplicatedPluginManager.class);
        register.implementation(ComponentContainer.Scope.PROVIDED, PluginSyncService.class, DefaultPluginSyncService.class);
        register.implementation(ComponentContainer.Scope.PROVIDED, ClusterImportService.class, DefaultClusterImportService.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, ClusterImportListener.class);
        if (ClusterServicesRegistrar.isClustered(register)) {
            ClusterServicesRegistrar.registerDatabaseLockService(register);
            ClusterServicesRegistrar.registerClusteredReplicatedIndexManager(register);
        } else {
            ClusterServicesRegistrar.registerJvmLockService(register);
            ClusterServicesRegistrar.registerNonClusteredReplicatedIndexManager(register);
        }
    }

    private static boolean isClustered(ComponentContainer register) {
        ClusterNodeProperties clusterNodeProperties = register.getComponentInstance(ClusterNodeProperties.class);
        return clusterNodeProperties != null && clusterNodeProperties.getNodeId() != null;
    }

    private static void registerDatabaseLockService(ComponentContainer register) {
        register.implementation(ComponentContainer.Scope.INTERNAL, ClusterNodeHeartbeatService.class, StartableClusterNodeHeartbeatService.class);
        register.implementation(ComponentContainer.Scope.PROVIDED, ClusterLockService.class, StartableDatabaseClusterLockService.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, ClusterLockDao.class, JiraClusterLockDao.class);
        ClusterServicesRegistrar.registerHeartbeatDao(register, JiraClusterNodeHeartBeatDao.class);
    }

    private static void registerJvmLockService(ComponentContainer register) {
        register.implementation(ComponentContainer.Scope.PROVIDED, ClusterLockService.class, SimpleClusterLockService.class);
        register.implementation(ComponentContainer.Scope.INTERNAL, ClusterNodeHeartbeatService.class, NullClusterNodeHeartbeatService.class);
        ClusterServicesRegistrar.registerHeartbeatDao(register, NullJiraClusterNodeHeartBeatDao.class);
    }

    private static void registerHeartbeatDao(ComponentContainer register, Class<? extends TimedClusterNodeHeartBeatDao> implClass) {
        MultipleKeyRegistrant.registrantFor(implClass).implementing(ClusterNodeHeartBeatDao.class).implementing(TimedClusterNodeHeartBeatDao.class).registerWith(ComponentContainer.Scope.INTERNAL, register);
    }

    private static void registerClusteredReplicatedIndexManager(ComponentContainer register) {
        register.implementation(ComponentContainer.Scope.PROVIDED, ReplicatedIndexManager.class, DefaultReplicatedIndexManager.class);
    }

    private static void registerNonClusteredReplicatedIndexManager(ComponentContainer register) {
        register.implementation(ComponentContainer.Scope.PROVIDED, ReplicatedIndexManager.class, NullReplicatedIndexManager.class);
    }
}

