/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.ObjectConfigurationPropertyImpl;
import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.jira.util.JiraUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesGeneratorObjectConfigurationProperty
extends ObjectConfigurationPropertyImpl {
    private static final Logger log = LoggerFactory.getLogger(ValuesGeneratorObjectConfigurationProperty.class);
    private final ValuesGenerator valuesGenerator;

    public ValuesGeneratorObjectConfigurationProperty(String name, String description, String defaultValue, int type, String typeName, String valueGeneratorClass, String enabledConditionClass) {
        this(name, description, defaultValue, type, typeName, valueGeneratorClass, enabledConditionClass, ValuesGeneratorObjectConfigurationProperty.class.getClassLoader());
    }

    public ValuesGeneratorObjectConfigurationProperty(String name, String description, String defaultValue, int type, String typeName, String valueGeneratorClass, String enabledConditionClass, ClassLoader classLoader) {
        super(name, description, defaultValue, type, typeName, enabledConditionClass, classLoader);
        ValuesGenerator valuesGenerator = ValuesGenerator.NONE;
        try {
            Class<ValuesGenerator> valuesGeneratorClass = classLoader.loadClass(valueGeneratorClass);
            valuesGenerator = this.createValuesGenerator(valuesGeneratorClass);
        }
        catch (Exception e) {
            log.warn("Could not create class: " + valueGeneratorClass, (Throwable)e);
        }
        this.valuesGenerator = valuesGenerator;
    }

    @VisibleForTesting
    ValuesGenerator createValuesGenerator(Class<ValuesGenerator> valuesGeneratorClass) {
        return JiraUtils.loadComponent(valuesGeneratorClass);
    }

    @Override
    protected Map getInternalValues(Map userParams) {
        Map values = this.valuesGenerator.getValues(userParams);
        if (values == null) {
            return Collections.emptyMap();
        }
        return values;
    }
}

