/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.workflow.WorkflowDescriptorXmlUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.jira.workflow.ImmutableWorkflowDescriptor;
import com.atlassian.jira.workflow.JiraWorkflowDTO;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachingWorkflowDescriptorStore
implements WorkflowDescriptorStore {
    private final Cache<String, CacheObject<ImmutableWorkflowDescriptor>> workflowCache;
    private final CachedReference<String[]> allNamesCache;
    private final WorkflowDescriptorStore delegate;

    public CachingWorkflowDescriptorStore(WorkflowDescriptorStore delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.workflowCache = cacheManager.getCache(CachingWorkflowDescriptorStore.class.getName() + ".workflowCache", (CacheLoader)new WorkflowCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.allNamesCache = cacheManager.getCachedReference(CachingWorkflowDescriptorStore.class.getName() + ".allNamesCache", (Supplier)new AllNamesSupplier());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.workflowCache.removeAll();
        this.allNamesCache.reset();
    }

    @EventListener
    public void onWorkflowDescriptorXmlUpdatedEvent(WorkflowDescriptorXmlUpdatedEvent event) {
        this.removeWorkflowFromCache(event.getWorkflowName());
    }

    @Override
    public ImmutableWorkflowDescriptor getWorkflow(String name) throws FactoryException {
        if (name == null) {
            throw new IllegalArgumentException("Workflow name cannot be null!");
        }
        return (ImmutableWorkflowDescriptor)((Object)((CacheObject)this.workflowCache.get((Object)name)).getValue());
    }

    @Override
    public boolean removeWorkflow(String name) {
        boolean deleted;
        if (name == null) {
            throw new IllegalArgumentException("Workflow name cannot be null!");
        }
        try {
            deleted = this.delegate.removeWorkflow(name);
        }
        finally {
            this.removeWorkflowFromCache(name);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveWorkflow(String name, WorkflowDescriptor workflowDescriptor, boolean replace) throws DataAccessException {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null!");
        }
        if (workflowDescriptor == null) {
            throw new IllegalArgumentException("workflowDescriptor may not be null!");
        }
        try {
            boolean bl = this.delegate.saveWorkflow(name, workflowDescriptor, replace);
            return bl;
        }
        finally {
            this.removeWorkflowFromCache(name);
        }
    }

    @Override
    public String[] getWorkflowNames() {
        String[] names = (String[])this.allNamesCache.get();
        return Arrays.copyOf(names, names.length);
    }

    @Override
    public List<JiraWorkflowDTO> getAllJiraWorkflowDTOs() {
        return this.delegate.getAllJiraWorkflowDTOs();
    }

    private void removeWorkflowFromCache(String name) {
        this.workflowCache.remove((Object)name);
        this.allNamesCache.reset();
    }

    private class WorkflowCacheLoader
    implements CacheLoader<String, CacheObject<ImmutableWorkflowDescriptor>> {
        private WorkflowCacheLoader() {
        }

        public CacheObject<ImmutableWorkflowDescriptor> load(@Nonnull String name) {
            try {
                return CacheObject.wrap(CachingWorkflowDescriptorStore.this.delegate.getWorkflow(name));
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class AllNamesSupplier
    implements Supplier<String[]> {
        private AllNamesSupplier() {
        }

        public String[] get() {
            return CachingWorkflowDescriptorStore.this.delegate.getWorkflowNames();
        }
    }
}

