/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.LocaleUtils;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.language.Language;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraLocaleUtils
extends LocaleUtils {
    public static final String DEFAULT_LOCALE_ID = "-1";
    public static final String DEFAULT_LOCALE_I18N_KEY = "admin.common.phrases.default.locale";
    private static final Logger log = LoggerFactory.getLogger(JiraLocaleUtils.class);
    private static final BuildUtilsInfo BUILD_UTILS_INFO = new BuildUtilsInfoImpl();
    private List<Locale> availableLocales = null;

    @ClusterSafe(value="Local. Locales are essentially program artefacts.")
    public synchronized List<Locale> getInstalledLocales() {
        if (this.availableLocales == null) {
            this.availableLocales = this.calculateAvailableLocales(Locale.getDefault());
        }
        return this.availableLocales;
    }

    @ClusterSafe(value="Local. Locales are essentially program artefacts.")
    public synchronized void resetInstalledLocales() {
        this.availableLocales = null;
    }

    public Map<String, String> getInstalledLocalesWithDefault(Locale defaultLocale, I18nHelper helper) {
        Locale usersLocale = helper.getLocale();
        LinkedHashMap<String, String> locales = new LinkedHashMap<String, String>();
        String label = helper.getText(DEFAULT_LOCALE_I18N_KEY, defaultLocale.getDisplayName(defaultLocale));
        locales.put(DEFAULT_LOCALE_ID, label);
        List<Locale> installedLocales = this.calculateAvailableLocales(usersLocale);
        for (Locale installedLocale : installedLocales) {
            if (installedLocale.equals(defaultLocale)) continue;
            locales.put(installedLocale.toString(), installedLocale.getDisplayName(installedLocale));
        }
        return ImmutableMap.copyOf(locales);
    }

    public static Locale parseLocale(String locale) {
        return LocaleParser.parseLocale((String)locale);
    }

    protected List<Locale> calculateAvailableLocales(Locale userLocale) {
        ArrayList<Object> localeList;
        HashMap<String, Locale> locales = new HashMap<String, Locale>();
        try {
            localeList = new ArrayList(super.getInstalledLocales());
            for (Locale locale : localeList) {
                locales.put(locale.toString(), locale);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collection unavailableLocales = BUILD_UTILS_INFO.getUnavailableLocales();
        List list = ComponentAccessor.getPluginAccessor().getEnabledModuleDescriptorsByClass(LanguageModuleDescriptor.class);
        for (LanguageModuleDescriptor descriptor : list) {
            Locale loc = ((Language)descriptor.getModule()).getLocale();
            locales.put(loc.toString(), loc);
        }
        localeList = new ArrayList(locales.values());
        for (Locale unavailableLocale : unavailableLocales) {
            if (!localeList.contains(unavailableLocale)) continue;
            log.warn("The '" + unavailableLocale.getDisplayName() + "' locale is not permitted to run in this build of JIRA. Please contact Atlassian for further details.");
            localeList.remove(unavailableLocale);
        }
        Collections.sort(localeList, new LocaleComparator(userLocale));
        return ImmutableList.copyOf(localeList);
    }

    private static class LocaleComparator
    implements Comparator<Locale> {
        private final Locale usersLocale;
        private Collator collator;

        public LocaleComparator(Locale usersLocale) {
            this.usersLocale = usersLocale;
            this.collator = Collator.getInstance(usersLocale);
        }

        @Override
        public int compare(Locale l1, Locale l2) {
            String displayName1 = l1.getDisplayName(this.usersLocale);
            String displayName2 = l2.getDisplayName(this.usersLocale);
            if (displayName1 == null) {
                return -1;
            }
            if (displayName2 == null) {
                return 1;
            }
            return this.collator.compare(displayName1, displayName2);
        }
    }
}

