/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class StripHtmlMarkup
extends WebWorkBodyTagSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(StripHtmlMarkup.class);
    private String expression;

    public void setValue(String expression) {
        this.expression = Strings.nullToEmpty((String)expression);
    }

    public int doEndTag() {
        String html = this.resolveValue();
        String htmlStrippedContent = this.stripAllHtml(html);
        this.writeValue(htmlStrippedContent);
        return 6;
    }

    @Nonnull
    private String resolveValue() {
        return Strings.nullToEmpty((String)this.findString(this.expression));
    }

    @Nonnull
    private String stripAllHtml(@Nonnull String html) {
        return Jsoup.clean((String)html, (Whitelist)Whitelist.none());
    }

    private void writeValue(@Nonnull String encodedValue) {
        try {
            this.pageContext.getOut().write(encodedValue);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to strip markup from a given expression; exception message: " + e.getMessage());
            LOGGER.debug("Failed to strip markup from expression: " + this.expression, (Throwable)e);
        }
    }
}

