/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.dispatcher.JiraWebworkViewDispatcher;
import com.atlassian.plugin.ModuleCompleteKey;
import org.apache.commons.lang.StringUtils;
import webwork.config.util.ActionInfo;

public class SoyTemplateAddress {
    private String completeKey;
    private String templateName;

    public static SoyTemplateAddress address(ActionInfo.ViewInfo viewInfo) {
        String defaultCompleteModuleKey = viewInfo.getActionInfo().getSource();
        String viewTemplateValue = StringUtils.defaultString((String)viewInfo.getViewValue()).trim();
        return SoyTemplateAddress.address(defaultCompleteModuleKey, viewTemplateValue);
    }

    public static SoyTemplateAddress address(String defaultCompleteModuleKey, String viewTemplateValue) {
        if (StringUtils.isEmpty((String)viewTemplateValue)) {
            throw new IllegalArgumentException("Illegal Soy template name : Its not specified");
        }
        String templateName = StringUtils.substringAfter((String)viewTemplateValue, (String)"/").trim();
        String pluginAndModule = StringUtils.substringBefore((String)viewTemplateValue, (String)"/").trim();
        if (StringUtils.isEmpty((String)templateName) || StringUtils.isEmpty((String)pluginAndModule)) {
            throw new IllegalArgumentException(String.format("Illegal Soy template name '%s'.   A valid name might be 'com.company.pluginKey:moduleKey/templateName' or ':moduleKey/templateName'", viewTemplateValue));
        }
        if (StringUtils.countMatches((String)viewTemplateValue, (String)":") != 1) {
            throw new IllegalArgumentException(String.format("Illegal Soy template name '%s'.   A valid name might be 'com.company.pluginKey:moduleKey/templateName' or ':moduleKey/templateName'", viewTemplateValue));
        }
        ModuleCompleteKey completeKey = JiraWebworkViewDispatcher.isFromCore(defaultCompleteModuleKey) ? new ModuleCompleteKey("jira.webresources", "soy-templates") : new ModuleCompleteKey(defaultCompleteModuleKey);
        Pair<String, String> pair = SoyTemplateAddress.splitAndTrim(pluginAndModule);
        String moduleKey = (String)pair.second();
        if (StringUtils.isEmpty((String)moduleKey)) {
            throw new IllegalArgumentException(String.format("Illegal Soy template name '%s'.  A valid name might be 'com.company.pluginKey:moduleKey/templateName' or ':moduleKey/templateName'", viewTemplateValue));
        }
        String pluginKey = ((String)pair.first()).equals(".") || ((String)pair.first()).equals("") ? completeKey.getPluginKey().trim() : ((String)pair.first()).trim();
        SoyTemplateAddress template = new SoyTemplateAddress();
        template.completeKey = pluginKey + ":" + moduleKey;
        template.templateName = templateName;
        return template;
    }

    private static Pair<String, String> splitAndTrim(String pluginModule) {
        String[] split = pluginModule.split(":");
        String pluginKey = split.length < 1 ? "" : split[0].trim();
        String moduleKey = split.length < 2 ? "" : split[1].trim();
        return Pair.of((Object)pluginKey, (Object)moduleKey);
    }

    public String getCompleteKey() {
        return this.completeKey;
    }

    public String getTemplateName() {
        return this.templateName;
    }
}

