/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.UserNameComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class UserBrowserFilter
extends PagerFilter<ApplicationUser> {
    public static final String ANY_APPLICATION_ACCESS_FILTER = "-1";
    public static final String NO_APPLICATION_ACCESS_FILTER = "-2";
    public String userSearchFilter = null;
    public String group = null;
    private final Locale userLocale;
    private final ApplicationRoleManager roleManager;
    private AccessFilterType applicationFilterType = AccessFilterType.IGNORE;
    private ApplicationKey applicationFilter = null;

    public UserBrowserFilter(Locale userLocale, ApplicationRoleManager roleManager) {
        this.userLocale = userLocale;
        this.roleManager = roleManager;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = FilterUtils.verifyString(group);
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void setApplicationFilter(String applicationFilter) {
        this.applicationFilterType = AccessFilterType.IGNORE;
        this.applicationFilter = null;
        switch (applicationFilter) {
            case "-1": {
                this.applicationFilterType = AccessFilterType.SPECIAL_ANY;
                break;
            }
            case "-2": {
                this.applicationFilterType = AccessFilterType.SPECIAL_NONE;
                break;
            }
            default: {
                try {
                    Option role = this.roleManager.getRole(ApplicationKey.valueOf((String)applicationFilter));
                    if (!role.isDefined()) break;
                    this.applicationFilterType = AccessFilterType.REGULAR;
                    this.applicationFilter = ((ApplicationRole)role.get()).getKey();
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public String getApplicationFilter() {
        switch (this.applicationFilterType) {
            case SPECIAL_ANY: {
                return ANY_APPLICATION_ACCESS_FILTER;
            }
            case SPECIAL_NONE: {
                return NO_APPLICATION_ACCESS_FILTER;
            }
            case REGULAR: {
                return this.applicationFilter.value();
            }
        }
        return null;
    }

    public List<ApplicationUser> getFilteredUsers() throws Exception {
        List<ApplicationUser> unfilteredUsers = ApplicationUsers.from(this.getUsersFilteredByGroup());
        if (this.userSearchFilter == null && this.applicationFilterType == AccessFilterType.IGNORE) {
            return Lists.newArrayList(unfilteredUsers);
        }
        Iterable users = Iterables.filter(unfilteredUsers, (Predicate)new Predicate<ApplicationUser>(){

            public boolean apply(ApplicationUser user) {
                return UserBrowserFilter.this.isUserIncluded(user);
            }
        });
        ArrayList filteredUsers = Lists.newArrayList((Iterable)users);
        Collections.sort(filteredUsers, new UserNameComparator(this.userLocale));
        return filteredUsers;
    }

    private Iterable<User> getUsersFilteredByGroup() {
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class);
        if (this.group != null) {
            MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(this.group).returningAtMost(-1);
            return crowdService.search((Query)membershipQuery);
        }
        UserQuery query = new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        return crowdService.search((Query)query);
    }

    private boolean isUserIncluded(ApplicationUser user) {
        boolean included = true;
        included = this.includeBasedOnUserSearch(user, included);
        included &= this.includeBasedOnApplicationAccess(user, included);
        return included;
    }

    private boolean includeBasedOnUserSearch(ApplicationUser user, boolean included) {
        return this.userSearchFilter == null ? included : this.includeBasedOnUserString(included, this.userSearchFilter, user.getName(), user.getEmailAddress(), user.getDisplayName());
    }

    private boolean includeBasedOnApplicationAccess(ApplicationUser user, boolean included) {
        if (!included) {
            return false;
        }
        switch (this.applicationFilterType) {
            case REGULAR: {
                return this.roleManager.userHasRole(user, this.applicationFilter);
            }
            case SPECIAL_NONE: {
                return !this.roleManager.hasAnyRole(user);
            }
            case SPECIAL_ANY: {
                return this.roleManager.hasAnyRole(user);
            }
        }
        return true;
    }

    private boolean includeBasedOnUserString(boolean included, String filterValue, String ... userValues) {
        if (included && filterValue != null) {
            String lowerCaseValue = filterValue.toLowerCase();
            for (int i = 0; i < userValues.length; ++i) {
                if (!StringUtils.containsIgnoreCase((CharSequence)userValues[i], (CharSequence)lowerCaseValue)) continue;
                return true;
            }
            return false;
        }
        return included;
    }

    private static enum AccessFilterType {
        SPECIAL_ANY,
        SPECIAL_NONE,
        REGULAR,
        IGNORE;

    }
}

