/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.web.action.admin.workflow.analytics.WorkflowTransitionTabEvent;
import com.atlassian.jira.web.action.util.workflow.WorkflowEditorTransitionConditionUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.tabs.WorkflowTransitionTabProvider;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewWorkflowTransition
extends AbstractWorkflowTransitionAction {
    private final ConstantsManager constantsManager;
    private final WorkflowActionsBean workflowActionsBean;
    private final WorkflowTransitionTabProvider workflowTransitionTabProvider;
    private final EventPublisher eventPublisher;
    private int up;
    private int down;
    private String count;
    private String currentCount;
    private String descriptorTab;

    public ViewWorkflowTransition(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, ConstantsManager constantsManager, WorkflowService workflowService, WorkflowTransitionTabProvider workflowTransitionTabProvider, EventPublisher eventPublisher) {
        super(workflow, step, transition, pluginAccessor, workflowService);
        this.constantsManager = constantsManager;
        this.eventPublisher = eventPublisher;
        this.workflowActionsBean = new WorkflowActionsBean();
        this.workflowTransitionTabProvider = workflowTransitionTabProvider;
    }

    public ViewWorkflowTransition(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, ConstantsManager constantsManager, WorkflowService workflowService, WorkflowTransitionTabProvider workflowTransitionTabProvider, EventPublisher eventPublisher) {
        super(workflow, transition, pluginAccessor, workflowService);
        this.constantsManager = constantsManager;
        this.eventPublisher = eventPublisher;
        this.workflowActionsBean = new WorkflowActionsBean();
        this.workflowTransitionTabProvider = workflowTransitionTabProvider;
    }

    public StepDescriptor getStepDescriptor(ConditionalResultDescriptor conditionalResultDescriptor) {
        int targetStepId = conditionalResultDescriptor.getStep();
        return this.getWorkflow().getDescriptor().getStep(targetStepId);
    }

    public Status getStatus(String id) {
        return this.constantsManager.getStatus(id);
    }

    public Status getStatusObject(String id) {
        return this.constantsManager.getStatusObject(id);
    }

    @RequiresXsrfCheck
    public String doMoveWorkflowFunctionUp() throws Exception {
        List postFunctions = this.getTransition().getUnconditionalResult().getPostFunctions();
        if (this.up <= 0 || this.up >= postFunctions.size()) {
            this.addErrorMessage(this.getText("admin.errors.workflows.invalid.index", "" + this.up));
        } else {
            Object toMove = postFunctions.get(this.up);
            CollectionReorderer.increasePosition(postFunctions, toMove);
            this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        }
        return this.getViewRedirect("&currentCount=workflow-function" + this.up);
    }

    @RequiresXsrfCheck
    public String doMoveWorkflowFunctionDown() throws Exception {
        List postFunctions = this.getTransition().getUnconditionalResult().getPostFunctions();
        if (this.down < 0 || this.down >= postFunctions.size() - 1) {
            this.addErrorMessage(this.getText("admin.errors.workflows.invalid.index", "" + this.down));
        } else {
            Object toMove = postFunctions.get(this.down);
            CollectionReorderer.decreasePosition(postFunctions, toMove);
            this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        }
        return this.getViewRedirect("&currentCount=workflow-function" + (this.down + 2));
    }

    @RequiresXsrfCheck
    public String doChangeLogicOperator() throws Exception {
        WorkflowEditorTransitionConditionUtil wetcu = new WorkflowEditorTransitionConditionUtil();
        wetcu.changeLogicOperator(this.getTransition(), this.getCount());
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getViewRedirect("");
    }

    protected String getViewRedirect(String postfix) {
        if (this.getStep() == null) {
            return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowTransition=" + this.getTransition().getId() + postfix);
        }
        return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.getStep().getId() + "&workflowTransition=" + this.getTransition().getId() + postfix);
    }

    public int getUp() {
        return this.up;
    }

    public void setUp(int up) {
        this.up = up;
    }

    public int getDown() {
        return this.down;
    }

    public void setDown(int down) {
        this.down = down;
    }

    public Collection getStepsForTransition() {
        return this.getWorkflow().getStepsForTransition(this.getTransition());
    }

    public boolean isInitial() {
        return this.getWorkflow().isInitialAction(this.getTransition());
    }

    public boolean isGlobal() {
        return this.getWorkflow().isGlobalAction(this.getTransition());
    }

    public boolean isCommon() {
        return this.getWorkflow().isCommonAction(this.getTransition());
    }

    public boolean isTransitionWithoutStepChange() {
        return this.getTransition().getUnconditionalResult().getStep() == -1;
    }

    public String getDescriptorTab() {
        ArrayList tabPanels;
        WorkflowTransitionTabProvider.WorkflowTransitionTab selectedTab;
        if (!TextUtils.stringSet((String)this.descriptorTab)) {
            this.descriptorTab = (String)ActionContext.getSession().get("jira.wf.editor.transition.tab.selected");
        }
        if ((selectedTab = (WorkflowTransitionTabProvider.WorkflowTransitionTab)Iterables.find((Iterable)(tabPanels = Lists.newArrayList(this.getTabPanels())), (Predicate)new Predicate<WorkflowTransitionTabProvider.WorkflowTransitionTab>(){

            public boolean apply(WorkflowTransitionTabProvider.WorkflowTransitionTab tab) {
                return tab.getModule().getKey().equals(ViewWorkflowTransition.this.descriptorTab);
            }
        }, null)) == null) {
            this.descriptorTab = !tabPanels.isEmpty() ? ((WorkflowTransitionTabProvider.WorkflowTransitionTab)tabPanels.get(0)).getModule().getKey() : "";
        }
        return this.descriptorTab;
    }

    public void setDescriptorTab(String descriptorTab) {
        if (TextUtils.stringSet((String)descriptorTab)) {
            ActionContext.getSession().put("jira.wf.editor.transition.tab.selected", descriptorTab);
        }
        this.descriptorTab = descriptorTab;
        this.eventPublisher.publish((Object)new WorkflowTransitionTabEvent(descriptorTab));
    }

    public FieldScreen getFieldScreen() {
        return this.workflowActionsBean.getFieldScreenForView(this.getTransition());
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getCurrentCount() {
        return this.currentCount;
    }

    public void setCurrentCount(String currentCount) {
        this.currentCount = currentCount;
    }

    public Iterator<WorkflowTransitionTabProvider.WorkflowTransitionTab> getTabPanels() {
        return this.workflowTransitionTabProvider.getTabs(this.getTransition(), this.getWorkflow()).iterator();
    }

    public String getTabPanelContent() {
        return this.workflowTransitionTabProvider.getTabContentHtml(this.getDescriptorTab(), this.getTransition(), this.getWorkflow());
    }
}

