/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.AbstractBrowser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.bean.UserBrowserFilter;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.builder.ToStringBuilder;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;
import webwork.util.BeanUtil;

@WebSudoRequired
public class UserBrowser
extends AbstractBrowser {
    private List<ApplicationUser> users;
    private final UserUtil userUtil;
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final UserManager userManager;
    private final AvatarService avatarService;
    private final SimpleLinkManager simpleLinkManager;
    private final ApplicationRoleManager applicationRoleManager;

    public UserBrowser(UserUtil userUtil, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserManager userManager, AvatarService avatarService, SimpleLinkManager simpleLinkManager, ApplicationRoleManager applicationRoleManager) {
        this.userUtil = userUtil;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userManager = userManager;
        this.avatarService = avatarService;
        this.simpleLinkManager = simpleLinkManager;
        this.applicationRoleManager = applicationRoleManager;
    }

    protected String doExecute() throws Exception {
        String emailFilterParam = this.getSingleParam("emailFilter");
        String groupParam = this.getSingleParam("group");
        String maxUsersPerPage = this.getSingleParam("max");
        if ("".equals(emailFilterParam) || "".equals(groupParam)) {
            this.resetPager();
            this.setStart("0");
        }
        BeanUtil.setProperties((Map)this.params, (Object)((Object)this.getFilter()));
        if (TextUtils.stringSet((String)maxUsersPerPage)) {
            this.getFilter().setMax(Integer.parseInt(maxUsersPerPage));
        }
        if (this.getBrowsableItems().size() <= this.getPager().getStart()) {
            this.setStart("0");
        }
        return super.doExecute();
    }

    @Override
    public PagerFilter getPager() {
        return this.getFilter();
    }

    @Override
    public void resetPager() {
        ActionContext.getSession().put("jira.user.filter", null);
    }

    public UserBrowserFilter getFilter() {
        UserBrowserFilter filter = (UserBrowserFilter)((Object)ActionContext.getSession().get("jira.user.filter"));
        if (filter == null) {
            filter = new UserBrowserFilter(this.getLocale(), this.applicationRoleManager);
            ActionContext.getSession().put("jira.user.filter", filter);
        }
        return filter;
    }

    @Override
    public List<ApplicationUser> getCurrentPage() {
        return this.getFilter().getCurrentPage(this.getBrowsableItems());
    }

    @Override
    public List<ApplicationUser> getBrowsableItems() {
        if (this.users == null) {
            try {
                this.users = this.getFilter().getFilteredUsers();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception getting users: " + e), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.users;
    }

    public Iterator getGroups() {
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        return this.crowdService.search((Query)query).iterator();
    }

    public Iterator getGroupsForUser(ApplicationUser user) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery).iterator();
    }

    public boolean getRolesEnabled() {
        return this.applicationRoleManager.rolesEnabled();
    }

    public Iterator<ApplicationRole> getApplicationRolesForUser(ApplicationUser user) {
        return this.applicationRoleManager.getRolesForUser(user).iterator();
    }

    public List<ApplicationRoleSelectItem> getApplicationRoles() {
        Set roles = this.applicationRoleManager.getRoles();
        ImmutableList.Builder defaults = ImmutableList.builder();
        if (roles.size() > 1) {
            defaults.add((Object)new ApplicationRoleSelectItem("-1", this.getI18nHelper().getText("common.filters.any")));
        }
        defaults.add((Object)new ApplicationRoleSelectItem("-2", this.getI18nHelper().getText("common.words.none")));
        return (List)Stream.concat(defaults.build().stream(), roles.stream().map(ApplicationRoleSelectItem::of)).collect(CollectorsUtil.toImmutableList());
    }

    public String getDirectoryForUser(ApplicationUser user) {
        return this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName();
    }

    public Collection<ApplicationUser> getUsers() {
        return this.getBrowsableItems();
    }

    public boolean isRemoteUserPermittedToEditSelectedUser(ApplicationUser user) {
        return user != null && this.userManager.canUpdateUser(user) && (this.isSystemAdministrator() || !this.getGlobalPermissionManager().hasPermission(44, user));
    }

    public boolean isRemoteUserPermittedToEditSelectedUsersGroups(ApplicationUser user) {
        return this.userManager.canUpdateGroupMembershipForUser(user);
    }

    public UserUtil getUserUtil() {
        return this.userUtil;
    }

    public URI getAvatarUrl(String username) {
        return this.avatarService.getAvatarURL(this.getLoggedInUser(), username, Avatar.Size.SMALL);
    }

    public Collection<SimpleLink> getOpsbarLinks() {
        return this.simpleLinkManager.getLinksForSection("system.admin.userbrowser.opsbar", this.getLoggedInUser(), this.getJiraHelper());
    }

    private JiraHelper getJiraHelper() {
        HashMap params = new HashMap();
        return new JiraHelper(ServletActionContext.getRequest(), null, params);
    }

    public static class ApplicationRoleSelectItem {
        private final String name;
        private final String value;

        public ApplicationRoleSelectItem(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public static ApplicationRoleSelectItem of(ApplicationRole role) {
            return new ApplicationRoleSelectItem(role.getKey().value(), role.getName());
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("value", (Object)this.value).toString();
        }
    }
}

