/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.group.GroupAccessLabelsManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class GroupLabels {
    private final ApplicationRoleManager roleManager;
    private final GroupAccessLabelsManager labelsManager;
    private final JiraAuthenticationContext authenticationContext;

    public GroupLabels(ApplicationRoleManager roleManager, GroupAccessLabelsManager labelsManager, JiraAuthenticationContext authenticationContext) {
        this.roleManager = roleManager;
        this.labelsManager = labelsManager;
        this.authenticationContext = authenticationContext;
    }

    public List<GroupLabelView> getGroupLabels(Group group, Optional<Long> directory) {
        Preconditions.checkState((boolean)this.roleManager.rolesEnabled(), (Object)"Roles should be enabled to check labels");
        ImmutableList.Builder labels = ImmutableList.builder();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        GroupAccessLabelsManager.GroupAccessLabels groupLabels = this.labelsManager.getForGroup(group, directory);
        if (groupLabels.isAdmin()) {
            labels.add((Object)new GroupLabelView(i18n.getText("admin.viewgroup.labels.admin.text"), i18n.getText("admin.viewgroup.labels.admin.description")));
        }
        if (groupLabels.getAccessibleApplications().size() == 1) {
            ApplicationRole role = groupLabels.getAccessibleApplications().stream().findAny().orElse(null);
            labels.add((Object)new GroupLabelView(role.getName(), i18n.getText("admin.viewgroup.labels.application.access.single.description", role.getName())));
        } else if (groupLabels.getAccessibleApplications().size() > 1) {
            labels.add((Object)new GroupLabelView(i18n.getText("admin.viewgroup.labels.application.access.multiple.text"), i18n.getText("admin.viewgroup.labels.application.access.multiple.description")));
        }
        return labels.build();
    }

    public static class GroupLabelView {
        private final String text;
        private final String title;

        public GroupLabelView(String text, String title) {
            this.text = text;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getText() {
            return this.text;
        }
    }
}

