/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.web.action.admin.issuesecurity.SchemeAwareIssueSecurityAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class AddIssueSecurity
extends SchemeAwareIssueSecurityAction {
    private Long securityLevel;
    private String type;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final UserKeyService userKeyService;

    public AddIssueSecurity(IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager issueSecurityTypeManager, IssueSecurityLevelManager issueSecurityLevelManager, UserKeyService userKeyService) {
        super(issueSecuritySchemeManager, issueSecurityTypeManager);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.userKeyService = userKeyService;
    }

    protected void doValidation() {
        try {
            if (this.schemeNotSelected()) {
                this.addErrorMessage(this.getText("admin.errors.must.select.a.scheme.for.the.issue.security", "\"Permission Schemes\""));
                return;
            }
            if (this.securityNotSelected()) {
                this.addErrorMessage(this.getText("admin.errors.must.select.a.issue.security.for.this.issue.security"));
                return;
            }
            if (this.typeNotSelected()) {
                this.addErrorMessage(this.getText("admin.errors.must.select.a.type.for.the.issue.security"));
                return;
            }
            if (!this.validateIssueSecurityType()) {
                return;
            }
            this.validateUniqueIssueSecurity();
        }
        catch (GenericEntityException e) {
            this.addErrorMessage(this.getText("admin.errors.an.error.occured.adding.the.issue.security") + ":\n" + e.getMessage());
        }
    }

    private boolean schemeNotSelected() throws GenericEntityException {
        return this.getSchemeId() == null || this.getScheme() == null;
    }

    private boolean securityNotSelected() {
        return this.getSecurity() == null;
    }

    private boolean typeNotSelected() {
        return !TextUtils.stringSet((String)this.getType());
    }

    private boolean validateIssueSecurityType() {
        JiraServiceContext jiraServiceContext = this.getJiraServiceContext();
        ((SecurityType)this.issueSecurityTypeManager.getSchemeType(this.getType())).doValidation(this.getType(), this.getParameters(), jiraServiceContext);
        return !jiraServiceContext.getErrorCollection().hasAnyErrors();
    }

    private void validateUniqueIssueSecurity() throws GenericEntityException {
        for (IssueSecurityLevelPermission securityToCheck : this.getExistingSecurities()) {
            if (!this.typesMatch(securityToCheck) || !this.parametersMatch(this.newSecurityParameter(), securityToCheck)) continue;
            this.addErrorMessage(this.getText("admin.errors.this.issue.security.already.exists"));
            break;
        }
    }

    private List<IssueSecurityLevelPermission> getExistingSecurities() throws GenericEntityException {
        return this.getSchemeManager().getPermissionsBySecurityLevel(this.securityLevel);
    }

    private boolean typesMatch(IssueSecurityLevelPermission securityToMatch) {
        return this.type.equals(securityToMatch.getType());
    }

    private boolean parametersMatch(String newSecurityParam, IssueSecurityLevelPermission securityToMatch) {
        return this.haveNoParam(newSecurityParam, securityToMatch) || this.haveMatchingParams(newSecurityParam, securityToMatch);
    }

    private boolean haveNoParam(String newSecurityParameter, IssueSecurityLevelPermission securityToMatch) {
        return newSecurityParameter == null && securityToMatch.getParameter() == null;
    }

    private boolean haveMatchingParams(String newSecurityParameter, IssueSecurityLevelPermission securityToMatch) {
        return newSecurityParameter != null && newSecurityParameter.equals(securityToMatch.getParameter());
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        SchemeEntity entity = new SchemeEntity(this.getType(), this.getParameter(this.getType()), (Object)this.getSecurity());
        this.issueSecuritySchemeManager.createSchemeEntity(this.getScheme(), entity);
        this.issueSecurityLevelManager.clearUsersLevels();
        return this.getRedirect("EditIssueSecurities!default.jspa?schemeId=" + this.getSchemeId());
    }

    public Map getTypes() {
        return this.issueSecurityTypeManager.getTypes();
    }

    public Long getSecurity() {
        return this.securityLevel;
    }

    public void setSecurity(Long security) {
        this.securityLevel = security;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map getParameters() {
        return ActionContext.getSingleValueParameters();
    }

    public String getParameter(String key) {
        String param = (String)this.getParameters().get(key);
        if (key.equals("user")) {
            param = this.userKeyService.getKeyForUsername(param);
        }
        return TextUtils.stringSet((String)param) ? param : null;
    }

    private String newSecurityParameter() {
        return this.getParameter(this.getType());
    }

    public GenericValue getSecurityLevel(Long id) throws Exception {
        return this.issueSecurityLevelManager.getIssueSecurityLevel(id);
    }
}

