/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.converters.DatePickerConverter;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.admin.customfields.AbstractEditConfigurationItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import webwork.action.Action;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditCustomFieldDefaults
extends AbstractEditConfigurationItemAction {
    private Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private Long fieldConfigSchemeId;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueFactory issueFactory;

    public EditCustomFieldDefaults(IssueFactory issueFactory, FieldLayoutManager fieldLayoutManager, FieldConfigSchemeManager fieldConfigSchemeManager, ManagedConfigurationItemService managedConfigurationItemService) {
        super(managedConfigurationItemService);
        this.issueFactory = issueFactory;
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @Override
    public String doDefault() throws Exception {
        EditCustomFieldDefaults.populateDefaults(this.getFieldConfig(), this.fieldValuesHolder);
        return super.doDefault();
    }

    public static void populateDefaults(FieldConfig config, Map<String, Object> customFieldValuesHolder) {
        CustomField cf = config.getCustomField();
        Object defaultValues = cf.getCustomFieldType().getDefaultValue(config);
        if (defaultValues != null) {
            CustomFieldParamsImpl paramsFromIssue = new CustomFieldParamsImpl(cf, defaultValues);
            paramsFromIssue.transformObjectsToStrings();
            customFieldValuesHolder.put(cf.getId(), paramsFromIssue);
        }
    }

    protected void doValidation() {
        if (this.validateFieldLocked()) {
            return;
        }
        CustomField customField = this.getCustomField();
        Map params = ActionContext.getParameters();
        HashMap modifiableParams = Maps.newHashMap((Map)params);
        modifiableParams.put(CustomFieldUtils.createSearchParam((String)customField.getId(), (String)CustomFieldUtils.getParamKeyRequireProjectIds()), new String[]{Boolean.TRUE.toString()});
        customField.validateFromActionParams((Map)modifiableParams, (ErrorCollection)this, this.getFieldConfig());
        if (this.hasAnyErrors()) {
            customField.populateFromParams(this.fieldValuesHolder, ActionContext.getParameters());
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        CustomField customField = this.getCustomField();
        HashMap map = new HashMap();
        ActionContext.getContext();
        Map actionParams = ActionContext.getParameters();
        if ("true".equals(ParameterUtils.getStringParam((Map)actionParams, (String)"useCurrentDate"))) {
            customField.getCustomFieldType().setDefaultValue(this.getFieldConfig(), (Object)DatePickerConverter.USE_NOW_DATE);
        } else {
            customField.populateFromParams(map, actionParams);
            Object customFieldDefault = customField.getValueFromParams(map);
            customField.getCustomFieldType().setDefaultValue(this.getFieldConfig(), customFieldDefault);
        }
        return this.getRedirect("ViewCustomFields.jspa");
    }

    public String getCustomFieldHtml() {
        CustomField customField = this.getCustomField();
        FieldConfig config = this.getFieldConfig();
        Map displayParameters = MapBuilder.build((Object)"defaultScreen", (Object)"true", (Object)"objectValue", (Object)customField.getCustomFieldType().getDefaultValue(config));
        MutableIssue dummyIssue = this.getDummyIssue();
        FieldLayoutItem fieldLayoutItem = null;
        try {
            if (dummyIssue.getProjectObject() != null && dummyIssue.getIssueTypeObject() != null) {
                FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(dummyIssue.getProjectObject(), dummyIssue.getIssueTypeId());
                fieldLayoutItem = fieldLayout.getFieldLayoutItem(config.getCustomField().getId());
            }
        }
        catch (DataAccessException ex) {
            this.log.warn((Object)("Unable to resolve a field layout item when setting the default value of custom field with id: " + config.getCustomField().getId()), (Throwable)ex);
        }
        return customField.getCustomFieldType().getDescriptor().getEditDefaultHtml(config, this.fieldValuesHolder, (Issue)dummyIssue, (Action)this, displayParameters, fieldLayoutItem);
    }

    public Long getFieldConfigSchemeId() {
        return this.fieldConfigSchemeId;
    }

    public void setFieldConfigSchemeId(Long fieldConfigSchemeId) {
        this.fieldConfigSchemeId = fieldConfigSchemeId;
    }

    private MutableIssue getDummyIssue() {
        MutableIssue dummyIssue = this.issueFactory.getIssue();
        FieldConfigScheme fieldConfigScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(this.getFieldConfigSchemeId());
        if (fieldConfigScheme != null) {
            Collection associatedIssueTypes;
            List associatedProjects = fieldConfigScheme.getAssociatedProjectObjects();
            if (associatedProjects != null && associatedProjects.size() == 1) {
                dummyIssue.setProjectObject((Project)associatedProjects.iterator().next());
            }
            if ((associatedIssueTypes = fieldConfigScheme.getAssociatedIssueTypeObjects()) != null && associatedIssueTypes.size() == 1) {
                dummyIssue.setIssueTypeObject((IssueType)associatedIssueTypes.iterator().next());
            }
        }
        return dummyIssue;
    }
}

