/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseMaintenancePredicate;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ConfirmNewInstallationWithOldLicense
extends JiraWebActionSupport {
    static final String RADIO_OPTION_LICENSE = "license";
    static final String RADIO_OPTION_EVALUATION = "evaluation";
    static final String RADIO_OPTION_REMOVE_EXPIRED = "remove-expired";
    private static final String EXTERNAL_LINK_JIRA_LICENSE_VIEW_CLUSTERED = "external.link.jira.license.data.center.contact";
    private static final String EXTERNAL_LINK_JIRA_LICENSE_VIEW_TIMEBOMB = "external.link.jira.license.view.timebomb";
    private static final String CLUSTERED_TIMEBOMB_ANCHOR = "TimebombLicensesforTesting-TestingDataCentercompatibility";
    private static final String EXTERNAL_LINK_JIRA_LICENSE_VIEW = "external.link.jira.license.view";
    private static final String LICENSE_DESC_LINK_CONTENT = "licenseDescLinkContent";
    private static final String LICENSE_DESC_LINK_TIMEBOMB_CONTENT = "licenseDescLinkTimebombContent";
    private static final String CROWD_EMBEDDED_INTEGRATION_VERSION = "602";
    static final String MAINTENANCE_EXPIRY_PRIMARY_KEY = "admin.license.support.and.updates";
    static final String MAINTENANCE_EXPIRY_SECONDARY_KEY = "admin.license.renewal.target";
    static final String SUBSCRIPTION_EXPIRY_PRIMARY_KEY = "admin.license.evaluation";
    static final String SUBSCRIPTION_EXPIRY_SECONDARY_KEY = "admin.license.evaluation.renew";
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final CrowdService crowdService;
    private final GlobalPermissionManager permissionManager;
    private final ClusterManager clusterManager;
    private final UserManager userManager;
    private final JiraProperties jiraSystemProperties;
    private final JohnsonProvider johnsonProvider;
    private final LicenseMaintenancePredicate maintenancePredicate;
    private final JiraLicenseManager jiraLicenseManager;
    private String userName;
    private String password;
    private String licenseString;
    private String radioOption;
    private boolean licenseUpdated = false;
    private boolean installationConfirmed = false;
    private List<LicenseDetails> licensesDetails;
    private JiraLicenseService.ValidationResult validationResult;
    private boolean loginInvalid = false;
    private boolean radioOptionInvalid = false;

    public ConfirmNewInstallationWithOldLicense(JiraLicenseUpdaterService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, JiraSystemRestarter jiraSystemRestarter, CrowdService crowdService, GlobalPermissionManager permissionManager, JiraProperties jiraSystemProperties, ClusterManager clusterManager, UserManager userManager, JohnsonProvider johnsonProvider, LicenseMaintenancePredicate maintenancePredicate, JiraLicenseManager jiraLicenseManager) {
        this.jiraLicenseManager = (JiraLicenseManager)Assertions.notNull((String)"jiraLicenseManager", (Object)jiraLicenseManager);
        this.maintenancePredicate = (LicenseMaintenancePredicate)Assertions.notNull((String)"LicenseMaintenancePredicate", (Object)maintenancePredicate);
        this.crowdService = (CrowdService)Assertions.notNull((String)"crowdService", (Object)crowdService);
        this.clusterManager = (ClusterManager)Assertions.notNull((String)"clusterManager", (Object)clusterManager);
        this.johnsonProvider = (JohnsonProvider)Assertions.notNull((String)"johnsonProvider", (Object)johnsonProvider);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.jiraLicenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.permissionManager = (GlobalPermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraSystemRestarter = (JiraSystemRestarter)Assertions.notNull((String)"jiraSystemRestarter", (Object)jiraSystemRestarter);
        this.jiraSystemProperties = (JiraProperties)Assertions.notNull((String)"jiraSystemProperties", (Object)jiraSystemProperties);
    }

    private boolean shouldDisplay() {
        return this.getJohnsonEventContainer().getEvents().stream().anyMatch(ConfirmNewInstallationWithOldLicense::isLicenseEvent);
    }

    private boolean isEvaluationOptionDisplayable() {
        if (this.clusterManager.isClustered()) {
            return false;
        }
        boolean expiredDataCenterOrEnterpriseAgreement = this.getLicensesDetails().stream().filter(this.maintenancePredicate.negate()).anyMatch(lic -> lic.isDataCenter() || lic.isEnterpriseLicenseAgreement());
        return !expiredDataCenterOrEnterpriseAgreement;
    }

    private boolean areThereLicensesWithinMaintenance() {
        List<LicenseDetails> licensesDetails = this.getLicensesDetails();
        return licensesDetails.stream().anyMatch(this.maintenancePredicate);
    }

    public String doDefault() throws Exception {
        if (!this.shouldDisplay()) {
            return "securitybreach";
        }
        return "input";
    }

    protected void doValidation() {
        ApplicationUser user;
        if (!this.shouldDisplay()) {
            return;
        }
        if (StringUtils.isBlank((String)this.radioOption)) {
            this.log.warn((Object)"Neither the License nor the Install Confirmation have been supplied.");
            this.addErrorMessage(this.getText("admin.errors.no.license"));
            this.setRadioOptionInvalid(true);
            return;
        }
        if (this.getUserInfoAvailable() && ((user = this.getCrowdUser()) == null || this.nonAdminUpgradeAllowed() || !this.checkUserIsAdmin(user))) {
            return;
        }
        if (this.radioOption.equals(RADIO_OPTION_LICENSE)) {
            this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, this.licenseString);
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    private boolean checkUserIsAdmin(ApplicationUser applicationUser) {
        if (!this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, applicationUser)) {
            this.addErrorMessage(this.getText("admin.errors.no.admin.permission"));
            this.setLoginInvalid(true);
            return false;
        }
        return true;
    }

    private ApplicationUser getCrowdUser() {
        User user = this.crowdService.getUser(this.userName);
        if (user == null) {
            this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
            this.setLoginInvalid(true);
            return null;
        }
        try {
            this.crowdService.authenticate(this.userName, this.password);
            return ApplicationUsers.from(user);
        }
        catch (FailedAuthenticationException e) {
            this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
            this.setLoginInvalid(true);
            return null;
        }
    }

    protected String doExecute() throws Exception {
        if (!this.shouldDisplay()) {
            return "securitybreach";
        }
        Option<String> error = Option.none();
        switch (this.radioOption) {
            case "license": {
                error = this.executeNewLicense();
                break;
            }
            case "remove-expired": {
                error = this.removeOutOfMaintenanceLicenses();
                break;
            }
            case "evaluation": {
                this.jiraLicenseManager.confirmProceedUnderEvaluationTerms(this.userName);
                this.installationConfirmed = true;
                break;
            }
            default: {
                throw new IllegalStateException("This will never happen!");
            }
        }
        if (error.isDefined()) {
            return (String)error.get();
        }
        this.jiraSystemRestarter.ariseSirJIRA();
        JohnsonEventContainer cont = this.johnsonProvider.getContainer();
        Lists.newArrayList((Iterable)cont.getEvents()).stream().filter(Objects::nonNull).filter(ConfirmNewInstallationWithOldLicense::isLicenseEvent).forEach(arg_0 -> ((JohnsonEventContainer)cont).removeEvent(arg_0));
        cont.addEvent(new Event(EventType.get((String)"restart"), this.getText("system.error.restart.for.changes"), EventLevel.get((String)"fatal")));
        return "success";
    }

    private Option<String> executeNewLicense() {
        LicenseDetails licenseDetails = this.jiraLicenseService.setLicense(this.validationResult);
        if (!this.maintenancePredicate.test(licenseDetails)) {
            this.addError(RADIO_OPTION_LICENSE, this.getText("admin.errors.license.too.old"));
            return Option.option((Object)"error");
        }
        this.licenseUpdated = true;
        return Option.none();
    }

    private Option<String> removeOutOfMaintenanceLicenses() {
        List outOfDate;
        ImmutableList allLicenses = ImmutableList.copyOf((Iterable)this.jiraLicenseManager.getLicenses());
        if (allLicenses.equals(outOfDate = (List)allLicenses.stream().filter(this.maintenancePredicate.negate()).collect(CollectorsUtil.toImmutableList()))) {
            throw new IllegalStateException("Removing out of maintenance licenses would remove all JIRA licenses.");
        }
        this.jiraLicenseManager.removeLicenses((Iterable)outOfDate);
        return Option.none();
    }

    private static boolean isLicenseEvent(Event event) {
        return ImmutableList.of((Object)"license-too-old", (Object)"clustering-unlicensed", (Object)"subscription-expired").stream().map(EventType::get).anyMatch(key -> event.getKey().equals(key));
    }

    private JohnsonEventContainer getJohnsonEventContainer() {
        return this.johnsonProvider.getContainer();
    }

    private List<LicenseDetails> getLicensesDetails() {
        if (this.licensesDetails == null) {
            this.licensesDetails = ImmutableList.copyOf((Iterable)this.jiraLicenseManager.getLicenses());
        }
        return this.licensesDetails;
    }

    private Map<String, String> getLicensesStatusMessages() {
        List<LicenseDetails> licensesDetails = this.getLicensesDetails();
        HashMap<String, String> messages = new HashMap<String, String>();
        for (LicenseDetails licenseDetails : licensesDetails) {
            LicenseDetails.LicenseStatusMessage licenseStatusMessage = licenseDetails.getLicenseStatusMessage(this.getI18nHelper(), this.userManager);
            if (licenseStatusMessage == null) continue;
            messages.putAll(licenseStatusMessage.getAllMessages());
        }
        return messages;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLicense() {
        return this.licenseString;
    }

    public void setLicense(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getRadioOption() {
        return this.radioOption;
    }

    public void setRadioOption(String radioOption) {
        this.radioOption = radioOption;
    }

    public boolean getLoginInvalid() {
        return this.loginInvalid;
    }

    public void setLoginInvalid(boolean loginInvalid) {
        this.loginInvalid = loginInvalid;
    }

    public boolean getRadioOptionInvalid() {
        return this.radioOptionInvalid;
    }

    public void setRadioOptionInvalid(boolean radioOptionInvalid) {
        this.radioOptionInvalid = radioOptionInvalid;
    }

    private boolean nonAdminUpgradeAllowed() {
        return this.jiraSystemProperties.getBoolean("non.admin.upgrade");
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public String getCurrentBuildDate() {
        return this.getDateTimeFormatter().format(this.buildUtilsInfo.getCurrentBuildDate());
    }

    private boolean getUserInfoAvailable() {
        BuildNumComparator comparator = new BuildNumComparator();
        if (comparator.compare(this.buildUtilsInfo.getCurrentBuildNumber(), CROWD_EMBEDDED_INTEGRATION_VERSION) < 0) {
            return true;
        }
        String currentDatabaseVersion = this.getApplicationProperties().getString("jira.version.patched");
        return !Strings.isNullOrEmpty((String)currentDatabaseVersion) && comparator.compare(currentDatabaseVersion, CROWD_EMBEDDED_INTEGRATION_VERSION) > 0;
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String serverId = this.getServerId();
        data.put("serverId", serverId);
        data.put("errors", this.getErrors());
        data.put("radioOption", this.getRadioOption());
        data.put("radioOptionLicense", RADIO_OPTION_LICENSE);
        data.put("radioOptionEvaluation", RADIO_OPTION_EVALUATION);
        data.put("radioRemoveExpired", RADIO_OPTION_REMOVE_EXPIRED);
        data.put("expired", this.isAnyLicenseExpired());
        data.put("evaluationOptionDisplayable", this.isEvaluationOptionDisplayable());
        data.put("clustered", this.clusterManager.isClustered());
        data.put("thereAreValidLicenses", this.areThereLicensesWithinMaintenance());
        if (this.clusterManager.isClustered()) {
            data.put(LICENSE_DESC_LINK_CONTENT, this.getAnchorTagForLink(EXTERNAL_LINK_JIRA_LICENSE_VIEW_CLUSTERED, null));
            data.put(LICENSE_DESC_LINK_TIMEBOMB_CONTENT, this.getAnchorTagForLink(EXTERNAL_LINK_JIRA_LICENSE_VIEW_TIMEBOMB, CLUSTERED_TIMEBOMB_ANCHOR));
        } else {
            String[] linkParams = new String[]{this.getBuildUtilsInfo().getVersion(), this.getBuildUtilsInfo().getCurrentBuildNumber(), "Enterprise", serverId};
            data.put(LICENSE_DESC_LINK_CONTENT, this.getAnchorTagForLink(EXTERNAL_LINK_JIRA_LICENSE_VIEW, linkParams));
        }
        String generalErrorMessage = this.getErrorMessages().isEmpty() ? null : (String)this.getErrorMessages().iterator().next();
        data.put("loginErrorMessageContent", this.getLoginInvalid() ? generalErrorMessage : null);
        this.setLoginErrorMessageTitle(generalErrorMessage, data);
        data.put("radioOptionErrorMessageContent", this.getRadioOptionInvalid() ? generalErrorMessage : null);
        Map<String, String> licenseStatusMessages = this.getLicensesStatusMessages();
        if (licenseStatusMessages.get(MAINTENANCE_EXPIRY_PRIMARY_KEY) != null) {
            data.put("licenseStatusMessage1Content", licenseStatusMessages.get(MAINTENANCE_EXPIRY_PRIMARY_KEY));
            data.put("licenseStatusMessage2Content", licenseStatusMessages.get(MAINTENANCE_EXPIRY_SECONDARY_KEY));
        } else {
            data.put("licenseStatusMessage1Content", licenseStatusMessages.get(SUBSCRIPTION_EXPIRY_PRIMARY_KEY));
            data.put("licenseStatusMessage2Content", licenseStatusMessages.get(SUBSCRIPTION_EXPIRY_SECONDARY_KEY));
        }
        data.put("userNameValue", this.getUserName());
        data.put("licenseValue", this.getLicense());
        data.put("jiraTitle", this.getApplicationProperties().getDefaultBackedString("jira.title"));
        data.put("jiraLogoUrl", this.getApplicationProperties().getDefaultBackedString("jira.lf.logo.url"));
        data.put("resourcesContent", MetalResourcesManager.getMetalResources(this.getHttpRequest().getContextPath()));
        return data;
    }

    private boolean isAnyLicenseExpired() {
        return this.getLicensesDetails().stream().anyMatch(LicenseDetails::isExpired);
    }

    @ActionViewDataMappings(value={"success"})
    public Map<String, Object> getDataMapSuccess() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("licenseUpdated", this.licenseUpdated);
        data.put("installationConfirmed", this.installationConfirmed);
        data.put("jiraTitle", this.getApplicationProperties().getDefaultBackedString("jira.title"));
        data.put("jiraLogoUrl", this.getApplicationProperties().getDefaultBackedString("jira.lf.logo.url"));
        data.put("resourcesContent", MetalResourcesManager.getMetalResources(this.getHttpRequest().getContextPath()));
        return data;
    }

    private void setLoginErrorMessageTitle(String generalErrorMessage, Map<String, Object> data) {
        if (StringUtils.equals((String)generalErrorMessage, (String)this.getText("admin.errors.no.admin.permission"))) {
            data.put("loginErrorMessageTitle", this.getLoginInvalid() ? this.getText("admin.errors.no.admin.permission.title") : null);
        }
    }

    private String getAnchorTagForLink(String link, Object linkParams) {
        ExternalLinkUtil util = ExternalLinkUtilImpl.getInstance();
        if (linkParams != null) {
            return "<a href=\"" + util.getProperty(link, linkParams) + "\">";
        }
        return "<a href=\"" + util.getProperty(link) + "\">";
    }
}

