/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.util;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.entity.EntityListConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class FindMixedCaseUsernames {
    public static EntityListConsumer<String, Map<String, String>> fromStrings() {
        return new FromStringsConsumer();
    }

    public static EntityListConsumer<GenericValue, Map<String, String>> fromColumn(String columnName) {
        return new FromColumnConsumer(columnName);
    }

    public static EntityListConsumer<GenericValue, Map<String, List<Long>>> fromColumnAndReturnIds(String columnName) {
        return new FromColumnAndReturnIdsConsumer(columnName);
    }

    static class FromColumnAndReturnIdsConsumer
    implements EntityListConsumer<GenericValue, Map<String, List<Long>>> {
        private final String columnName;
        private final Map<String, List<Long>> results = new HashMap<String, List<Long>>();

        FromColumnAndReturnIdsConsumer(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public void consume(GenericValue gv) {
            String username = gv.getString(this.columnName);
            if (username == null) {
                return;
            }
            String lowerUsername = IdentifierUtils.toLowerCase((String)username);
            if (username.equals(lowerUsername)) {
                return;
            }
            Long id = gv.getLong("id");
            if (id == null) {
                return;
            }
            List<Long> ids = this.results.get(lowerUsername);
            if (ids == null) {
                ids = new ArrayList<Long>();
                this.results.put(lowerUsername, ids);
            }
            ids.add(id);
        }

        @Override
        public Map<String, List<Long>> result() {
            return this.results;
        }
    }

    static class FromColumnConsumer
    implements EntityListConsumer<GenericValue, Map<String, String>> {
        private final String columnName;
        private final FromStringsConsumer delegate = new FromStringsConsumer();

        FromColumnConsumer(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public void consume(GenericValue gv) {
            this.delegate.consume(gv.getString(this.columnName));
        }

        @Override
        public Map<String, String> result() {
            return this.delegate.result();
        }
    }

    static class FromStringsConsumer
    implements EntityListConsumer<String, Map<String, String>> {
        private final Set<String> seen = new HashSet<String>();
        private final Map<String, String> usernames = new HashMap<String, String>();

        FromStringsConsumer() {
        }

        @Override
        public void consume(String username) {
            String lowerUsername;
            if (username != null && this.seen.add(username) && !username.equals(lowerUsername = IdentifierUtils.toLowerCase((String)username))) {
                this.usernames.put(username, lowerUsername);
            }
        }

        @Override
        public Map<String, String> result() {
            return this.usernames;
        }
    }
}

