/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.AuditEntrySeverity;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationChangedValue;
import com.atlassian.jira.upgrade.tasks.role.MigrationGroupService;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.upgrade.tasks.role.UserWithPermissions;
import java.util.Collections;
import java.util.Set;

class MoveJira6xABPServiceDeskPermissions
extends MigrationTask {
    private static final String GROUP_ATTR_SERVICE_DESK = "synch.created.by.jira.service.desk";
    private static final String GROUP_ATTR_SERVICE_DESK_VALUE = "synch.created.by.jira.service.desk";
    private static final Group GROUP_SD_AGENTS = new ImmutableGroup("service-desk-agents");
    private final MigrationGroupService migrationGroupService;
    private final GlobalPermissionDao globalPermissionDao;

    MoveJira6xABPServiceDeskPermissions(MigrationGroupService migrationGroupService, GlobalPermissionDao globalPermissionDao) {
        this.migrationGroupService = migrationGroupService;
        this.globalPermissionDao = globalPermissionDao;
    }

    @Override
    MigrationState migrate(MigrationState state, boolean licenseSuppliedByUser) {
        Set<Group> sdAgentGroups = this.globalPermissionDao.groupsWithSdAgentPermission();
        for (Group sdAgentGroup : sdAgentGroups) {
            state = this.checkGroupAndMigrate(sdAgentGroup, state);
        }
        return state;
    }

    private MigrationState checkGroupAndMigrate(Group sdAgentGroup, MigrationState state) {
        Set<UserWithPermissions> usersInAgentGroup = this.migrationGroupService.getUsersInGroup(sdAgentGroup);
        boolean allUsersHaveUse = true;
        boolean anyUserHasUse = false;
        for (UserWithPermissions user : usersInAgentGroup) {
            boolean hasUse = user.hasAdminPermission() || user.hasUsePermission();
            allUsersHaveUse &= hasUse;
            anyUserHasUse |= hasUse;
        }
        if (allUsersHaveUse) {
            MigrationState migrationState = state.changeApplicationRole(ApplicationKeys.SERVICE_DESK, role -> this.migrateGroup((ApplicationRole)role, sdAgentGroup));
            MigrationChangedValue changedValue = new MigrationChangedValue(sdAgentGroup.getName(), "USE (permission), Agent (permission)", ApplicationKeys.SERVICE_DESK.value() + " (role)");
            AuditEntry event = new AuditEntry(this.getClass(), "Group added to Service Desk: " + sdAgentGroup.getName(), "Group was migrated as all users have both JIRA USE and Agent permissions", AssociatedItem.Type.APPLICATION_ROLE, ApplicationKeys.SERVICE_DESK.value(), changedValue);
            return migrationState.log(event);
        }
        if (anyUserHasUse) {
            StringBuilder builder = new StringBuilder().append("Service Desk Migration - cannot add Service Desk application role to group: '").append(sdAgentGroup.getName()).append("'\n").append("Group contains users with misconfigured permissions - not all users in the group are ").append("able to log in to JIRA, migration would cause privilege escalation.\n").append("Affected users:\n");
            String sep = "";
            for (UserWithPermissions user : usersInAgentGroup) {
                builder.append(sep).append(user.getUser().getName());
                sep = ", ";
            }
            return state.log(new AuditEntry(MoveJira6xABPServiceDeskPermissions.class, "Service Desk not migrated", builder.toString(), AssociatedItem.Type.APPLICATION_ROLE, null, Collections.emptyList(), AuditEntrySeverity.WARNING));
        }
        return state.log(new AuditEntry(MoveJira6xABPServiceDeskPermissions.class, "Service Desk not migrated", "There are " + usersInAgentGroup.size() + " users with Service Desk Agent permission who" + " do not have JIRA USE permission. In order to avoid allowing these users to log" + " in, the group '" + sdAgentGroup.getName() + "' has not been assigned to" + " Service Desk.", AssociatedItem.Type.APPLICATION_ROLE));
    }

    private ApplicationRole migrateGroup(ApplicationRole applicationRole, Group sdAgentGroup) {
        ApplicationRole roleWithGroup = applicationRole.addGroup(sdAgentGroup);
        if (this.shouldSetGroupAsDefault(sdAgentGroup)) {
            roleWithGroup = roleWithGroup.addGroupAsDefault(sdAgentGroup);
        }
        return roleWithGroup;
    }

    private boolean shouldSetGroupAsDefault(Group sdAgentGroup) {
        GroupWithAttributes groupWithAttributes = this.migrationGroupService.getGroupWithAttributes(sdAgentGroup);
        boolean groupHasAdmin = this.globalPermissionDao.groupsWithAdminPermission().contains(sdAgentGroup);
        return !groupHasAdmin && groupWithAttributes != null && GROUP_SD_AGENTS.equals((Object)sdAgentGroup) && "synch.created.by.jira.service.desk".equals(groupWithAttributes.getValue("synch.created.by.jira.service.desk"));
    }
}

