/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseUtils;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Move6xServiceDeskLicenseTo70Store
extends MigrationTask {
    private static final Logger log = LoggerFactory.getLogger(Move6xServiceDeskLicenseTo70Store.class);
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier sdEncodedLicenseSupplier;

    Move6xServiceDeskLicenseTo70Store(Jira6xServiceDeskPluginEncodedLicenseSupplier sdEncodedLicenseSupplier) {
        this.sdEncodedLicenseSupplier = sdEncodedLicenseSupplier;
    }

    @Override
    MigrationState migrate(MigrationState state, boolean licenseSuppliedByUser) {
        if (licenseSuppliedByUser) {
            return state.log(new AuditEntry(Move6xServiceDeskLicenseTo70Store.class, "Not moving old Service Desk license - license supplied by user", "The person importing JIRA has supplied a license to use; any existing Service Desk licenseinstalled in your system will be ignored in preference of the new license.", AssociatedItem.Type.LICENSE));
        }
        return (MigrationState)this.sdEncodedLicenseSupplier.get().map(License::new).filter(this::isValid6xServiceDeskLicense).map(sdLicense -> this.addLicenseIfNotPresent((License)sdLicense, state)).getOrElse((Object)state);
    }

    private MigrationState addLicenseIfNotPresent(License sdLicense, MigrationState state) {
        if (state.licenses().canAdd(sdLicense)) {
            return state.changeLicenses(license2 -> license2.addLicense(sdLicense)).log(new AuditEntry(Move6xServiceDeskLicenseTo70Store.class, "Moved Service Desk license to JIRA license store", "The existing Service Desk plugin license was moved to the JIRA license store to function as a license for the JIRA Service Desk application.", AssociatedItem.Type.LICENSE, sdLicense.getSEN(), new ChangedValue[0]));
        }
        return state.log(new AuditEntry(Move6xServiceDeskLicenseTo70Store.class, "Not moving old Service Desk license - new license present already", "An existing JIRA Service Desk license is installed already so will be used in preference of the old-style plugin license. ", AssociatedItem.Type.LICENSE));
    }

    private boolean isValid6xServiceDeskLicense(License license) {
        try {
            LicenseUtils.ServiceDeskLicenseType licenseType = LicenseUtils.determineServiceDeskLicenseType(license);
            if (licenseType == LicenseUtils.ServiceDeskLicenseType.TierBasedPricing || licenseType == LicenseUtils.ServiceDeskLicenseType.AgentBasedPricing) {
                return true;
            }
        }
        catch (MigrationFailedException migrationFailedException) {
            // empty catch block
        }
        log.debug("Invalid Service Desk license in plugin store.");
        return false;
    }
}

