/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.SearchTokenizer;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.MigrationLog;
import com.atlassian.jira.upgrade.tasks.role.MigrationLogDao;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationLogDaoImpl
implements MigrationLogDao {
    private static final Logger log = LoggerFactory.getLogger(MigrationLogDaoImpl.class);
    private static final long SYSADMIN_AUTHOR_TYPE = 1L;
    private static final String OFBIZ_AUDIT_ENTITY_NAME = "AuditLog";
    private static final String MIGRATION_AUDIT_CATEGORY_ID = "migration";
    private static final String MIGRATION_AUDIT_CATEGORY_NAME = "jira.auditing.category.migration";
    private static final String NO_KEY = "0";
    private final OfBizDelegator ofBizDelegator;

    public MigrationLogDaoImpl(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public void write(@Nonnull MigrationLog record) {
        for (AuditEntry event : record.events()) {
            try {
                this.store(event);
                log.info(event.getSourceClass() + ": JIRA 7.0 Role Migrations: " + event.toLogMessage());
            }
            catch (Exception e) {
                log.warn("Error in writing migration logs. Continuing...", (Throwable)e);
            }
        }
    }

    private void store(AuditEntry event) {
        HashMap values = Maps.newHashMap();
        values.put("created", new Timestamp(System.currentTimeMillis()));
        values.put("authorKey", null);
        values.put("summary", event.getSummary());
        values.put("category", MIGRATION_AUDIT_CATEGORY_ID);
        values.put("authorType", 1L);
        values.put("eventSourceName", event.getSourceClass().getSimpleName());
        values.put("description", event.getDescription());
        values.put("objectId", NO_KEY);
        values.put("objectName", event.getChangedObject() == null ? "No change" : event.getChangedObject());
        values.put("objectParentId", NO_KEY);
        values.put("objectParentName", "");
        values.put("objectType", event.getType().toString());
        values.put("searchField", MigrationLogDaoImpl.computeSearchField(event.getSummary(), event.getChangedValues(), event.getSourceClass().getSimpleName()));
        GenericValue gv = this.ofBizDelegator.createValue(OFBIZ_AUDIT_ENTITY_NAME, (Map)values);
        if (event.getChangedValues() != null) {
            Long entryId = gv.getLong("id");
            this.storeChangedValues(entryId, event.getChangedValues());
        }
    }

    public static String computeSearchField(@Nonnull String summary, @Nullable Iterable<ChangedValue> changedValues, String eventSource) {
        SearchTokenizer tokenizer = new SearchTokenizer();
        tokenizer.put(summary);
        tokenizer.put(MIGRATION_AUDIT_CATEGORY_NAME);
        if (StringUtils.isNotEmpty((CharSequence)eventSource)) {
            tokenizer.put(eventSource);
        }
        if (changedValues != null) {
            for (ChangedValue changedValue : changedValues) {
                tokenizer.put(changedValue.getName());
                tokenizer.put(changedValue.getFrom());
                tokenizer.put(changedValue.getTo());
            }
        }
        return tokenizer.getTokenizedString();
    }

    protected void storeChangedValues(Long entryOfBizId, @Nonnull Iterable<ChangedValue> changedValues) {
        for (ChangedValue changedValue : changedValues) {
            HashMap values = Maps.newHashMap();
            values.put("logId", entryOfBizId);
            values.put("name", changedValue.getName());
            values.put("deltaFrom", changedValue.getFrom());
            values.put("deltaTo", changedValue.getTo());
            this.ofBizDelegator.createValue("AuditChangedValue", (Map)values);
        }
    }
}

