/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.fugue.Option;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

final class GlobalPermissionDaoImpl
extends GlobalPermissionDao {
    private static final String AGENT_GLOBAL_PERMISSION_NAME = "com.atlassian.servicedesk.agent.access";
    private final OfBizDelegator db;
    private final Supplier<Set<Group>> useGroups;
    private final Supplier<Multimap<Group, GlobalPermissionDao.AdminPermission>> adminGroups;
    private final Supplier<Set<Group>> sdAgentGroups;

    GlobalPermissionDaoImpl(OfBizDelegator db) {
        this.db = (OfBizDelegator)Assertions.notNull((String)"db", (Object)db);
        this.useGroups = Suppliers.memoize(() -> this.getGlobalGroups("USE"));
        this.adminGroups = Suppliers.memoize(this::getAdminGroups);
        this.sdAgentGroups = Suppliers.memoize(() -> this.getGlobalGroups(AGENT_GLOBAL_PERMISSION_NAME));
    }

    @Override
    Set<Group> groupsWithUsePermission() {
        return (Set)this.useGroups.get();
    }

    @Override
    Set<Group> groupsWithAdminPermission() {
        return ((Multimap)this.adminGroups.get()).keySet();
    }

    @Override
    Multimap<Group, GlobalPermissionDao.AdminPermission> groupsWithAdminPermissionAndPermissionType() {
        return (Multimap)this.adminGroups.get();
    }

    @Override
    Set<Group> groupsWithSdAgentPermission() {
        return (Set)this.sdAgentGroups.get();
    }

    private ImmutableSet<Group> getGlobalGroups(String permission) {
        return (ImmutableSet)this.db.findByAnd("GlobalPermissionEntry", (Map)ImmutableMap.of((Object)"permission", (Object)permission)).stream().map(gv -> gv.getString("group_id")).filter(Objects::nonNull).map(ImmutableGroup::new).collect(CollectorsUtil.toImmutableSet());
    }

    private Multimap<Group, GlobalPermissionDao.AdminPermission> getAdminGroups() {
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        entityExpressions.add(new EntityExpr("permission", EntityOperator.EQUALS, (Object)GlobalPermissionDao.AdminPermission.ADMIN.ofBizKey()));
        entityExpressions.add(new EntityExpr("permission", EntityOperator.EQUALS, (Object)GlobalPermissionDao.AdminPermission.SYSADMIN.ofBizKey()));
        HashMultimap result = HashMultimap.create();
        List adminGroupValues = this.db.findByOr("GlobalPermissionEntry", entityExpressions, (List)ImmutableList.of((Object)"permission"));
        for (GenericValue gv : adminGroupValues) {
            Option<GlobalPermissionDao.AdminPermission> permission;
            String groupName = gv.getString("group_id");
            String permissionKey = gv.getString("permission");
            if (groupName == null || permissionKey == null || !(permission = GlobalPermissionDao.AdminPermission.from(permissionKey)).isDefined()) continue;
            ImmutableGroup group = new ImmutableGroup(groupName);
            result.put((Object)group, permission.get());
        }
        return ImmutableMultimap.copyOf((Multimap)result);
    }
}

