/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.upgrade.tasks.role.AuditEntrySeverity;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class AuditEntry {
    private final Class<?> sourceClass;
    private final String summary;
    private final List<ChangedValue> changedValues;
    private final String description;
    private final String changedObject;
    private final AssociatedItem.Type eventType;
    private final AuditEntrySeverity severity;

    public AuditEntry(Class<?> sourceClass, String summary, String description, AssociatedItem.Type eventType) {
        this(sourceClass, summary, description, eventType, null, new ChangedValue[0]);
    }

    public AuditEntry(Class<?> sourceClass, String summary, String description, AssociatedItem.Type eventType, @Nullable String changedObject, ChangedValue ... changedValues) {
        this(sourceClass, summary, description, eventType, changedObject, (Iterable<ChangedValue>)ImmutableList.copyOf((Object[])((Object[])Assertions.notNull((String)"changedValues", (Object)changedValues))), AuditEntrySeverity.INFO);
    }

    public AuditEntry(Class<?> sourceClass, String summary, String description, AssociatedItem.Type eventType, @Nullable String changedObject, Iterable<ChangedValue> changedValues, AuditEntrySeverity severity) {
        this.sourceClass = (Class)Assertions.notNull((String)"sourceClass", sourceClass);
        this.summary = (String)Assertions.notNull((String)"summary", (Object)summary);
        this.changedValues = ImmutableList.copyOf((Iterable)((Iterable)Assertions.notNull((String)"changedValues", changedValues)));
        this.description = (String)Assertions.notNull((String)"description", (Object)description);
        this.changedObject = changedObject;
        this.eventType = (AssociatedItem.Type)Assertions.notNull((String)"eventType", (Object)eventType);
        this.severity = severity;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public String getSummary() {
        return this.summary;
    }

    public Iterable<ChangedValue> getChangedValues() {
        return this.changedValues;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getChangedObject() {
        return this.changedObject;
    }

    public AssociatedItem.Type getType() {
        return this.eventType;
    }

    public AuditEntrySeverity getSeverity() {
        return this.severity;
    }

    public String toLogMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSummary()).append(" - ").append(this.getDescription());
        if (this.getChangedObject() != null) {
            sb.append(" - ");
            sb.append(this.getChangedObject());
        }
        if (!this.changedValues.isEmpty()) {
            sb.append(" - ");
            String changed = StreamSupport.stream(this.getChangedValues().spliterator(), false).map(changedValue -> "(" + changedValue.getName() + ": " + changedValue.getFrom() + " --> " + changedValue.getTo() + ")").collect(Collectors.joining(", "));
            sb.append(changed);
        }
        sb.append(", type: ").append(this.eventType.name());
        return sb.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditEntry that = (AuditEntry)o;
        return Objects.equals(this.sourceClass, that.sourceClass) && Objects.equals(this.summary, that.summary) && Objects.equals(this.changedValues, that.changedValues) && Objects.equals(this.description, that.description) && Objects.equals(this.changedObject, that.changedObject) && Objects.equals((Object)this.severity, (Object)that.severity) && Objects.equals(this.eventType, that.eventType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceClass, this.summary, this.changedValues, this.description, this.changedObject, this.eventType, this.severity});
    }

    public String toString() {
        return "AuditEntry{sourceClass=" + this.sourceClass + ", summary='" + this.summary + '\'' + ", changedValues=" + this.changedValues + ", description='" + this.description + '\'' + ", changedObject='" + this.changedObject + '\'' + ", license=" + this.eventType + ", severity=" + (Object)((Object)this.severity) + '}';
    }
}

