/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.upgrade.DefaultUpgradeConstraints;
import com.atlassian.jira.util.BuildUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import javax.inject.Inject;

public class RenaissanceUpgradeConstraints
extends DefaultUpgradeConstraints {
    private final int cloudDarkAgesBuildNumber;
    private final BuildNumComparator buildNumComparator = new BuildNumComparator();
    private final FeatureManager featureManager;

    @Inject
    public RenaissanceUpgradeConstraints(FeatureManager featureManager, BuildUtilsInfo buildUtilsInfo) {
        super(buildUtilsInfo);
        this.featureManager = featureManager;
        this.cloudDarkAgesBuildNumber = Integer.parseInt(BuildUtils.getCloudDarkAgesBuildNumber());
    }

    @Override
    public int getTargetDatabaseBuildNumber() {
        if (this.darkAgesEnabled()) {
            return this.cloudDarkAgesBuildNumber;
        }
        return super.getTargetDatabaseBuildNumber();
    }

    @Override
    public boolean shouldRunTask(String upgradeTaskNumber) {
        if (this.darkAgesEnabled()) {
            return this.buildNumComparator.compare(upgradeTaskNumber, BuildUtils.getCloudDarkAgesBuildNumber()) <= 0;
        }
        return super.shouldRunTask(upgradeTaskNumber);
    }

    private boolean darkAgesEnabled() {
        return this.featureManager.isOnDemand() && !this.featureManager.isEnabled(CoreFeatures.LICENSE_ROLES_ENABLED);
    }
}

