/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.studio.startup;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.studio.startup.JiraDefaultLocator;
import com.atlassian.jira.studio.startup.Locator;
import com.atlassian.jira.studio.startup.ServiceLocator;
import com.atlassian.jira.studio.startup.StudioStartupHooks;
import com.atlassian.jira.studio.startup.SystemPropertyLocator;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;

public final class StudioStartupHooksLocator {
    private static volatile StudioStartupHooks preset;
    @ClusterSafe(value="Programming artifacts only.")
    private static LazyReference<StudioStartupHooks> ref;

    private StudioStartupHooksLocator() {
    }

    public static StudioStartupHooks getStudioStartupHooks() {
        StudioStartupHooks presetHooks = preset;
        if (presetHooks != null) {
            return presetHooks;
        }
        return (StudioStartupHooks)ref.get();
    }

    @VisibleForTesting
    static void setStartupHooks(StudioStartupHooks hooks) {
        preset = hooks;
    }

    @VisibleForTesting
    static void resetStartupHooks() {
        preset = null;
    }

    static {
        ref = new LazyReference<StudioStartupHooks>(){
            private final Locator[] LOCATORS = new Locator[]{new SystemPropertyLocator(), new ServiceLocator(), new JiraDefaultLocator()};

            @Nonnull
            protected StudioStartupHooks create() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = StudioStartupHooksLocator.class.getClassLoader();
                }
                for (Locator locator : this.LOCATORS) {
                    StudioStartupHooks hooks = locator.locate(classLoader);
                    if (hooks == null) continue;
                    return hooks;
                }
                throw new IllegalStateException("Unable to find StudioStartupHooks.");
            }
        };
    }
}

