/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.startup.JiraLauncher;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.h2.tools.Server;

public class EmbeddedDatabaseServerLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(EmbeddedDatabaseServerLauncher.class);
    private static final Integer port = JiraSystemProperties.getInstance().getInteger("jira.embedded.h2.server.port");
    private Server h2Server;
    private final Lock h2ServerLock = new ReentrantLock();

    public static boolean isEnabled() {
        return port != null;
    }

    public static Integer getPort() {
        return port;
    }

    @Override
    public void start() {
        block5: {
            this.h2ServerLock.lock();
            try {
                if (this.h2Server != null || port == null) break block5;
                log.info((Object)("starting embedded H2 server on port " + port));
                try {
                    this.h2Server = Server.createTcpServer((String[])new String[]{"-tcpPort", port.toString()}).start();
                }
                catch (SQLException e) {
                    this.h2Server = null;
                    throw new RuntimeException("unable to start embedded H2 server", e);
                }
            }
            finally {
                this.h2ServerLock.unlock();
            }
        }
    }

    @Override
    public void stop() {
        this.h2ServerLock.lock();
        try {
            if (this.h2Server != null) {
                log.info((Object)("stopping embedded H2 server on port " + port));
                this.h2Server.stop();
            }
        }
        finally {
            this.h2ServerLock.unlock();
        }
    }
}

