/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ApplicationSetup {
    private final ApplicationManager applicationManager;
    private final GroupManager groupManager;
    private final ApplicationRoleManager applicationRoleManager;

    public ApplicationSetup(ApplicationManager applicationManager, GroupManager groupManager, ApplicationRoleManager applicationRoleManager) {
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.applicationManager = (ApplicationManager)Assertions.notNull((String)"applicationManager", (Object)applicationManager);
    }

    public ApplicationSetup initialiseApplications(Group ... extraGroups) {
        Assertions.notNull((String)"extraGroups", (Object)extraGroups);
        for (ApplicationRole role : this.applicationRoleManager.getRoles()) {
            Group group = this.getOrCreateGroup(this.getDefaultGroupName(role.getKey()));
            ImmutableSet groups = ApplicationSetup.builder(role.getGroups()).add((Object)group).addAll(Arrays.asList(extraGroups)).build();
            ImmutableSet defaultGroups = ApplicationSetup.builder(role.getDefaultGroups()).add((Object)group).build();
            this.applicationRoleManager.setRole(role.withGroups((Iterable)groups, (Iterable)defaultGroups).withSelectedByDefault(role.isDefined()));
        }
        return this;
    }

    public ApplicationSetup setupAdminForDefaultApplications(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        this.applicationRoleManager.getRoles().forEach(role -> role.getDefaultGroups().forEach(group -> this.addUserToGroup(user, (Group)group)));
        return this;
    }

    private void addUserToGroup(ApplicationUser user, Group group) {
        if (!this.groupManager.isUserInGroup(user, group)) {
            try {
                this.groupManager.addUserToGroup(user, group);
            }
            catch (CrowdException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getDefaultGroupName(ApplicationKey applicationKey) {
        return (String)this.applicationManager.getApplication(applicationKey).map(Application::getDefaultGroup).getOrElse(() -> String.format("%s-users", applicationKey.value()));
    }

    private static <T> ImmutableSet.Builder<T> builder(Set<T> set) {
        return ImmutableSet.builder().addAll(set);
    }

    private Group getOrCreateGroup(String groupName) {
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            return group;
        }
        try {
            return this.groupManager.createGroup(groupName);
        }
        catch (CrowdException e) {
            throw new RuntimeException("Unable to create group during setup.", e);
        }
    }
}

