/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUserDao;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplicationStatusServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationState state = this.getApplicationState();
        resp.setStatus(state == ApplicationState.ERROR ? 500 : 200);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.name()).append("\"}");
    }

    private ApplicationState getApplicationState() {
        if (this.hasErrors()) {
            return ApplicationState.ERROR;
        }
        if (!this.hasStarted()) {
            return ApplicationState.STARTING;
        }
        if (this.isFirstRun()) {
            return ApplicationState.FIRST_RUN;
        }
        if (!this.isUserCacheInitialized()) {
            return ApplicationState.STARTING;
        }
        return ApplicationState.RUNNING;
    }

    public boolean hasErrors() {
        JohnsonEventContainer johnsonEventContainer = this.getJohnsonContainer();
        if (johnsonEventContainer != null && johnsonEventContainer.hasEvents()) {
            Collection events = johnsonEventContainer.getEvents();
            for (Event event : events) {
                String level;
                if (event.getLevel() == null || !"error".equals(level = event.getLevel().getLevel()) && !"fatal".equals(level)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasStarted() {
        ComponentManager.State state = ComponentManager.getInstance().getState();
        return state.isComponentsRegistered() && state.isContainerInitialised() && state.isPluginSystemStarted() && state.isStarted();
    }

    private JohnsonEventContainer getJohnsonContainer() {
        JohnsonProvider provider = (JohnsonProvider)ComponentAccessor.getComponent(JohnsonProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getContainer();
    }

    private boolean isFirstRun() {
        return !JiraUtils.isSetup();
    }

    public boolean isUserCacheInitialized() {
        try {
            return ((OfBizUserDao)ComponentAccessor.getComponent(OfBizUserDao.class)).isCacheInitialized();
        }
        catch (Exception e) {
            return false;
        }
    }
}

