/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.scheduler.OfBizClusteredJob;
import com.atlassian.scheduler.caesium.spi.ClusteredJob;
import com.atlassian.scheduler.caesium.spi.ClusteredJobDao;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

@ParametersAreNonnullByDefault
public class OfBizClusteredJobDao
implements ClusteredJobDao {
    private static final Logger LOG = Logger.getLogger(OfBizClusteredJobDao.class);
    private final EntityEngine entityEngine;

    public OfBizClusteredJobDao(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Nullable
    public Date getNextRunTime(JobId jobId) {
        Long value;
        GenericValue gv = (GenericValue)Select.columns("nextRun").from("ClusteredJob").whereEqual("jobId", jobId.toString()).runWith(this.entityEngine).singleValue();
        if (gv != null && (value = gv.getLong("nextRun")) != null) {
            return new Date(value);
        }
        return null;
    }

    @Nullable
    public Long getVersion(JobId jobId) {
        GenericValue gv = (GenericValue)Select.columns("version").from("ClusteredJob").whereEqual("jobId", jobId.toString()).runWith(this.entityEngine).singleValue();
        return gv != null ? gv.getLong("version") : null;
    }

    @Nullable
    public ClusteredJob find(JobId jobId) {
        return (ClusteredJob)Select.from(Entity.CLUSTERED_JOB).whereEqual("jobId", jobId.toString()).runWith(this.entityEngine).singleValue();
    }

    @Nonnull
    public Collection<ClusteredJob> findByJobRunnerKey(JobRunnerKey jobRunnerKey) {
        List list = Select.from(Entity.CLUSTERED_JOB).whereEqual("jobRunnerKey", jobRunnerKey.toString()).runWith(this.entityEngine).asList();
        return ImmutableList.copyOf(list);
    }

    @Nonnull
    public Map<JobId, Date> refresh() {
        ImmutableMap.Builder jobs = ImmutableMap.builder();
        Select.columns("jobId", "nextRun").from("ClusteredJob").whereCondition((EntityCondition)new EntityExpr("nextRun", EntityOperator.NOT_EQUAL, null)).runWith(this.entityEngine).visitWith(gv -> jobs.put((Object)JobId.of((String)gv.getString("jobId")), (Object)new Date(gv.getLong("nextRun"))));
        return jobs.build();
    }

    @Nonnull
    public Set<JobRunnerKey> findAllJobRunnerKeys() {
        ImmutableSet.Builder keys = ImmutableSet.builder();
        Select.distinctString("jobRunnerKey").from("ClusteredJob").runWith(this.entityEngine).visitWith(jobRunnerKey -> keys.add((Object)JobRunnerKey.of((String)jobRunnerKey)));
        return keys.build();
    }

    public boolean create(ClusteredJob clusteredJob) {
        try {
            this.entityEngine.createValue(Entity.CLUSTERED_JOB, new OfBizClusteredJob(null, clusteredJob));
            return true;
        }
        catch (DataAccessException dae) {
            LOG.debug((Object)"Mid-air collision creating a clustered job (probably)", (Throwable)dae);
            return false;
        }
    }

    public boolean updateNextRunTime(JobId jobId, @Nullable Date date, long version) {
        Long nextRun = date != null ? Long.valueOf(date.getTime()) : null;
        int rows = Update.into("ClusteredJob").set("nextRun", nextRun).set("version", version + 1L).whereEqual("jobId", jobId.toString()).andEqual("version", version).execute(this.entityEngine);
        switch (rows) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        LOG.error((Object)("Unexpectedly hit multiple rows updating a clustered job's next run time!  jobId=" + jobId + "; date=" + date + "; version=" + version));
        return true;
    }

    public boolean delete(JobId jobId) {
        int rows = Delete.from("ClusteredJob").whereEqual("jobId", jobId.toString()).execute(this.entityEngine);
        switch (rows) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        LOG.error((Object)("Unexpectedly deleted multiple rows removing a clustered job!  jobId=" + jobId));
        return true;
    }
}

