/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.fugue.Option;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeIconRenderer;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.project.type.ProjectTypesDarkFeature;
import java.util.Optional;

public class ProjectTypeIconRendererImpl
implements ProjectTypeIconRenderer {
    private final ProjectTypeManager projectTypeManager;
    private final ProjectTypesDarkFeature darkFeature;

    public ProjectTypeIconRendererImpl(ProjectTypeManager projectTypeManager, ProjectTypesDarkFeature darkFeature) {
        this.projectTypeManager = projectTypeManager;
        this.darkFeature = darkFeature;
    }

    public Optional<String> getIconToRender(ProjectTypeKey key) {
        if (!this.darkFeature.isEnabled()) {
            return Optional.empty();
        }
        if (key == null || key.getKey() == null) {
            return this.getInaccessibleProjectTypeIcon();
        }
        Option projectType = this.projectTypeManager.getByKey(key);
        if (projectType.isDefined()) {
            return Optional.of(((ProjectType)projectType.get()).getIcon());
        }
        return this.getInaccessibleProjectTypeIcon();
    }

    private Optional<String> getInaccessibleProjectTypeIcon() {
        return Optional.of(this.projectTypeManager.getInaccessibleProjectType().getIcon());
    }
}

