/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class JiraBaseUrlCDNStrategy
implements CDNStrategy {
    static final String ENABLED_FEATURE_KEY = "jira.baseurl.cdn.enabled";
    static final String PREFIX_SYSTEM_PROPERTY = "jira.baseurl.cdn.prefix";
    private final JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();
    private final ApplicationProperties applicationProperties;

    public JiraBaseUrlCDNStrategy(ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
    }

    public boolean supportsCdn() {
        return this.getPrefixes().length > 0 && this.getAuthority() != null;
    }

    public String transformRelativeUrl(String relativeUrl) {
        return this.getPrefix(relativeUrl) + relativeUrl;
    }

    @Nullable
    private String getPrefix(String relativeUrl) {
        String[] prefixes = this.getPrefixes();
        if (prefixes.length == 0) {
            return null;
        }
        String prefix = prefixes[Math.abs(JiraBaseUrlCDNStrategy.stringHashCode(relativeUrl)) % prefixes.length];
        return prefix + "/" + this.getAuthority();
    }

    @Nullable
    private String getAuthority() {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        try {
            return new URL(baseUrl).getAuthority();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private String[] getPrefixes() {
        String prefixesString = this.jiraSystemProperties.getProperty(PREFIX_SYSTEM_PROPERTY);
        if (null == prefixesString) {
            return new String[0];
        }
        return (String[])Arrays.asList(prefixesString.split(",")).stream().filter(StringUtils::isNotBlank).toArray(String[]::new);
    }

    private static int stringHashCode(String value) {
        int hash = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + value.charAt(i);
        }
        return hash;
    }
}

