/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractPermissionCondition;
import com.atlassian.jira.plugin.webfragment.conditions.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Supplier;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasIssuePermissionCondition
extends AbstractPermissionCondition {
    private static final Logger log = LoggerFactory.getLogger(HasIssuePermissionCondition.class);

    public HasIssuePermissionCondition(PermissionManager permissionManager) {
        super(permissionManager);
    }

    public boolean shouldDisplay(final ApplicationUser user, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        final Issue issue = (Issue)params.get("issue");
        if (issue == null) {
            log.warn("Trying to run permission condition on an issue, but no issue exists");
            return false;
        }
        String cacheKey = HasIssuePermissionCondition.getHasPermissionKey((int)this.permission, (ApplicationUser)user, (Object[])new Object[]{issue.getKey()});
        return RequestCachingConditionHelper.cacheConditionResultInRequest((String)cacheKey, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return HasIssuePermissionCondition.this.permissionManager.hasPermission(HasIssuePermissionCondition.this.permission, issue, user);
            }
        });
    }
}

