/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.report.impl.SubTaskingIssueDecorator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.collections.set.ListOrderedSet;

class IssueSubTaskTransformer {
    private final Predicate includeSubTasksPredicate;

    public IssueSubTaskTransformer(Predicate includeSubTasksPredicate) {
        this.includeSubTasksPredicate = includeSubTasksPredicate;
    }

    Set getIssues(Set issues) {
        HashMap<Long, Issue> inputIssuesById = new HashMap<Long, Issue>();
        for (Object issue2 : issues) {
            Issue issue = (Issue)issue2;
            inputIssuesById.put(issue.getId(), issue);
        }
        ListOrderedMap resultIssueMap = new ListOrderedMap();
        for (Object issue1 : issues) {
            SubTaskingIssueDecorator issueDecorator;
            Issue issue = (Issue)issue1;
            if (!issue.isSubTask()) {
                if (resultIssueMap.containsKey(issue.getId())) continue;
                resultIssueMap.put(issue.getId(), new SubTaskingIssueDecorator(issue));
                continue;
            }
            if (!this.includeSubTasksPredicate.evaluate((Object)issue)) continue;
            if (!inputIssuesById.containsKey(issue.getParentId())) {
                resultIssueMap.put(issue.getId(), new SubTaskingIssueDecorator(issue));
                continue;
            }
            Long parentId = issue.getParentId();
            if (resultIssueMap.containsKey(parentId)) {
                issueDecorator = (SubTaskingIssueDecorator)resultIssueMap.get(parentId);
            } else {
                Issue parentIssue = (Issue)inputIssuesById.get(parentId);
                issueDecorator = new SubTaskingIssueDecorator(parentIssue);
                resultIssueMap.put(parentId, issueDecorator);
            }
            issueDecorator.addSubTask(issue);
        }
        ListOrderedSet result = new ListOrderedSet();
        result.addAll(resultIssueMap.values());
        return Collections.unmodifiableSet(result);
    }
}

