/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issueview;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import com.atlassian.jira.plugin.issueview.IssueViewFieldParamsImpl;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParamsHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueViewRequestParamsHelperImpl
implements IssueViewRequestParamsHelper {
    private static final Logger log = LoggerFactory.getLogger(IssueViewRequestParamsHelperImpl.class);
    private Map<String, String> fieldNamesMapping;
    private Set<String> nonIssueFields;
    private FieldManager fieldManager;

    public IssueViewRequestParamsHelperImpl(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
        HashMap<String, String> fieldsMapping = new HashMap<String, String>();
        fieldsMapping.put("pid", "project");
        fieldsMapping.put("comments", "comment");
        fieldsMapping.put("component", "components");
        fieldsMapping.put("due", "duedate");
        fieldsMapping.put("type", "issuetype");
        fieldsMapping.put("version", "versions");
        fieldsMapping.put("fixfor", "fixVersions");
        fieldsMapping.put("subtask", "subtasks");
        fieldsMapping.put("attachments", "attachment");
        fieldsMapping.put("resolved", "resolutiondate");
        fieldsMapping.put("aggregatetimeremainingestimate", "aggregatetimeestimate");
        this.fieldNamesMapping = Collections.unmodifiableMap(fieldsMapping);
        HashSet<String> nonIssue = new HashSet<String>();
        nonIssue.add("parent");
        nonIssue.add("link");
        nonIssue.add("title");
        this.nonIssueFields = Collections.unmodifiableSet(nonIssue);
    }

    @Override
    public IssueViewFieldParams getIssueViewFieldParams(Map requestParameters) {
        HashSet<String> fields = new HashSet<String>();
        HashSet<String> customFields = new HashSet<String>();
        boolean allCustomFields = false;
        boolean customViewRequested = false;
        Set<String> orderableFieldIds = this.getOrderableFieldIds();
        if (requestParameters != null && requestParameters.containsKey("field")) {
            customViewRequested = true;
            String[] fieldNames = (String[])requestParameters.get("field");
            if (fieldNames != null) {
                for (String fieldName : fieldNames) {
                    if ("allcustom".equals(fieldName)) {
                        allCustomFields = true;
                        continue;
                    }
                    if (fieldName.startsWith("customfield_")) {
                        CustomField customField = null;
                        try {
                            customField = this.fieldManager.getCustomField(fieldName);
                        }
                        catch (IllegalArgumentException ex) {
                            log.debug("Invalid field specified for custom issue XML view.", (Throwable)ex);
                        }
                        if (customField == null) continue;
                        customFields.add(fieldName);
                        continue;
                    }
                    String queryName = fieldName;
                    if (this.fieldNamesMapping.containsKey(fieldName)) {
                        queryName = this.fieldNamesMapping.get(fieldName);
                    }
                    if ("timetracking".equals(queryName)) {
                        this.processField("timeoriginalestimate", fields);
                        this.processField("timeestimate", fields);
                        this.processField("timespent", fields);
                        this.processField("aggregatetimeoriginalestimate", fields);
                        this.processField("aggregatetimeestimate", fields);
                        this.processField("aggregatetimespent", fields);
                        continue;
                    }
                    Field field = this.processField(queryName, fields);
                    if (field != null) continue;
                    log.debug("Invalid field specified for custom issue XML view: " + fieldName);
                }
            }
        }
        return new IssueViewFieldParamsImpl(customViewRequested, fields, orderableFieldIds, customFields, allCustomFields);
    }

    private Set<String> getOrderableFieldIds() {
        HashSet<String> orderableFieldIds = new HashSet<String>();
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (Field field : orderableFields) {
            orderableFieldIds.add(field.getId());
        }
        return orderableFieldIds;
    }

    private Field processField(String queryName, Set<String> fields) {
        Field field = this.fieldManager.getField(queryName);
        if (field != null) {
            fields.add(queryName);
        } else if (this.nonIssueFields.contains(queryName)) {
            fields.add(queryName);
        }
        return field;
    }
}

