/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class DefaultProjectPermissionSchemeHelper
implements ProjectPermissionSchemeHelper {
    private final PermissionSchemeManager permissionSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public DefaultProjectPermissionSchemeHelper(PermissionSchemeManager permissionSchemeManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @Override
    public List<Project> getSharedProjects(Scheme permissionScheme) {
        TreeSet sharedProjects = Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
        List projects = this.permissionSchemeManager.getProjects(permissionScheme);
        for (Project project : projects) {
            if (!this.hasEditPermission(this.authenticationContext.getUser(), project)) continue;
            sharedProjects.add(project);
        }
        return Lists.newArrayList((Iterable)sharedProjects);
    }

    boolean hasEditPermission(ApplicationUser user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project);
    }
}

