/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.util;

import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.mail.TemplateUser;
import com.atlassian.jira.mail.util.ByteArrayDataSource;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.web.ServletContextProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAttachmentsManagerImpl
implements MailAttachmentsManager {
    private static final Logger log = LoggerFactory.getLogger(MailAttachmentsManagerImpl.class);
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final ApplicationProperties applicationProperties;
    @ClusterSafe(value="This is a local object used in the creation of a single email")
    private final Map<MailAttachment, String> mailAttachments = Collections.synchronizedMap(Maps.newHashMap());

    public MailAttachmentsManagerImpl(AvatarService avatarService, UserManager userManager, AvatarManager avatarManager, ApplicationProperties applicationProperties) {
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getAvatarUrl(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        return this.getAvatarUrl(user);
    }

    @Override
    public String getAvatarUrl(TemplateUser templateUser) {
        return this.getAvatarUrl(templateUser.getName());
    }

    @Override
    public String getAvatarUrl(ApplicationUser user) {
        if (user != null && this.avatarService.isUsingExternalAvatar(this.getLoggedInUser(), user)) {
            return this.avatarService.getAvatarUrlNoPermCheck(user, Avatar.Size.defaultSize()).toString();
        }
        return this.addAttachmentAndReturnCid(this.createUserAvatarAttachment(user));
    }

    public String getIssueTypeIconUrl(IssueType issueType) {
        return issueType.getAvatar() == null ? this.getImageUrl(issueType.getIconUrlHtml()) : this.addAttachmentAndReturnCid(this.createIssueTypeAvatarAttachment(issueType));
    }

    private ApplicationUser getLoggedInUser() {
        return ComponentAccessor.getJiraAuthenticationContext().getUser();
    }

    private String addAttachmentAndReturnCid(MailAttachment mailAttachment) {
        if (this.mailAttachments.containsKey(mailAttachment)) {
            return this.buildCidUrl(this.mailAttachments.get(mailAttachment));
        }
        String cid = this.generateCid(mailAttachment);
        if (this.mailAttachments.containsValue(cid)) {
            cid = cid + UUID.randomUUID().toString();
        }
        this.mailAttachments.put(mailAttachment, cid);
        return this.buildCidUrl(cid);
    }

    private String buildCidUrl(String cid) {
        return "cid:" + cid;
    }

    private String generateCid(MailAttachment attachment) {
        return "jira-generated-image-" + attachment.getUniqueName();
    }

    @Override
    public String getImageUrl(String path) {
        ServletContext servletContext = ServletContextProvider.getServletContext();
        try {
            if (servletContext.getResource(path) == null) {
                return this.getAbsoluteUrl(path);
            }
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return this.getAbsoluteUrl(path);
        }
        return this.addAttachmentAndReturnCid(new ImageAttachment(path));
    }

    @Override
    public String getExternalImageUrl(String path) {
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                return path;
            }
            return this.addAttachmentAndReturnCid(new UrlImageAttachment(this.getAbsoluteUrl(path)));
        }
        catch (URISyntaxException e) {
            log.trace("Cannot understand URI: " + path, (Throwable)e);
            return path;
        }
    }

    protected String getAbsoluteUrl(String path) {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        try {
            URI uri = new URI(path);
            return uri.isAbsolute() ? path : StringUtils.stripEnd((String)baseUrl, (String)"/") + "/" + StringUtils.stripStart((String)path, (String)"/");
        }
        catch (URISyntaxException e) {
            log.trace("Cannot understand URI: " + path, (Throwable)e);
            return path;
        }
    }

    @Override
    public int getAttachmentsCount() {
        return this.mailAttachments.size();
    }

    @Override
    public Iterable<BodyPart> buildAttachmentsBodyParts() {
        Iterable bodyParts = Iterables.transform(this.mailAttachments.entrySet(), (Function)new Function<Map.Entry<MailAttachment, String>, BodyPart>(){

            public BodyPart apply(Map.Entry<MailAttachment, String> input) {
                BodyPart bodyPart = input.getKey().buildBodyPart();
                if (bodyPart != null) {
                    try {
                        String cid = input.getValue();
                        bodyPart.setHeader("Content-ID", String.format("<%s>", cid));
                    }
                    catch (MessagingException e) {
                        log.warn("Cannot add 'Content-ID' header to mail part", (Throwable)e);
                        return null;
                    }
                }
                return bodyPart;
            }
        });
        return Iterables.filter((Iterable)bodyParts, (Predicate)Predicates.notNull());
    }

    private AvatarAttachment createUserAvatarAttachment(ApplicationUser user) {
        String userName = null == user ? "anonymous" : user.getName();
        return new AvatarAttachment(this.avatarService.getAvatarTagged(user, user), "user: " + userName);
    }

    private AvatarAttachment createIssueTypeAvatarAttachment(IssueType issueType) {
        return new AvatarAttachment(issueType.getAvatar(), "issue type: " + issueType.getName());
    }

    private static class ToBodyPartConsumer
    implements Consumer<InputStream> {
        private BodyPart bodyPart;
        private final String contentType;

        private ToBodyPartConsumer(String contentType) {
            this.contentType = contentType;
        }

        public void consume(InputStream element) {
            try {
                this.bodyPart = new MimeBodyPart();
                this.bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(element, this.contentType)));
            }
            catch (MessagingException e) {
                log.warn("Cannot read avatar", (Throwable)e);
                this.bodyPart = null;
            }
            catch (IOException e) {
                log.warn("Cannot read avatar", (Throwable)e);
                this.bodyPart = null;
            }
        }

        private BodyPart getBodyPart() {
            return this.bodyPart;
        }
    }

    @Nonnull
    private class AvatarAttachment
    implements MailAttachment {
        private final Avatar avatar;
        private final String avatarOwnerDescription;

        private AvatarAttachment(Avatar avatar, String avatarOwnerDescription) {
            this.avatarOwnerDescription = avatarOwnerDescription;
            this.avatar = avatar;
        }

        @Override
        public BodyPart buildBodyPart() {
            try {
                ToBodyPartConsumer dataAccessor = new ToBodyPartConsumer(this.avatar.getContentType());
                MailAttachmentsManagerImpl.this.avatarManager.readAvatarData(this.avatar, AvatarManager.ImageSize.MEDIUM, (Consumer)dataAccessor);
                Option bodyPart = Option.option((Object)dataAccessor.getBodyPart());
                if (bodyPart.isDefined()) {
                    ((BodyPart)bodyPart.get()).setDisposition("inline");
                    return (BodyPart)bodyPart.get();
                }
                return null;
            }
            catch (FileNotFoundException e) {
                log.warn(String.format("Cannot add avatar as Mail attachment for '%s' - file not found", this.avatarOwnerDescription));
                return null;
            }
            catch (IOException e) {
                log.warn(String.format("Cannot add avatar as Mail attachment for '%s'", this.avatarOwnerDescription), (Throwable)e);
                return null;
            }
            catch (MessagingException e) {
                log.warn(String.format("Problem with disposition while adding avatar as Mail attachment for '%s'", this.avatarOwnerDescription), (Throwable)e);
                return null;
            }
        }

        @Override
        public String getUniqueName() {
            UUID uuid = UUID.randomUUID();
            return String.format("avatar-%s", uuid.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AvatarAttachment)) {
                return false;
            }
            AvatarAttachment that = (AvatarAttachment)o;
            return !(this.avatar == null ? that.avatar != null : !this.avatar.equals(that.avatar));
        }

        public int hashCode() {
            return this.avatar == null ? 0 : this.avatar.hashCode();
        }
    }

    private static class UrlImageAttachment
    extends ImageAttachment {
        private UrlImageAttachment(String imagePath) {
            super(imagePath);
        }

        @Override
        protected ImageAttachment.ResourceData getResourceData() throws MessagingException, IOException {
            try {
                URL url = new URL(this.imagePath);
                URLConnection connection = url.openConnection();
                return new ImageAttachment.ResourceData(connection.getContentType(), connection.getInputStream());
            }
            catch (MalformedURLException e) {
                throw new MessagingException("Malformed atttachment URL", (Exception)e);
            }
        }
    }

    private static class ImageAttachment
    implements MailAttachment {
        protected final String imagePath;

        private ImageAttachment(String imagePath) {
            Preconditions.checkNotNull((Object)imagePath);
            this.imagePath = imagePath;
        }

        @Override
        public BodyPart buildBodyPart() {
            try {
                ResourceData resourceData = this.getResourceData();
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(resourceData.inputStream, resourceData.mimeType)));
                bodyPart.setDisposition("inline");
                return bodyPart;
            }
            catch (MessagingException e) {
                log.warn(String.format("Cannot add image as Mail attachment: '%s'", this.imagePath), (Throwable)e);
                return null;
            }
            catch (IOException e) {
                log.warn(String.format("Cannot load resource for: '%s'", this.imagePath), (Throwable)e);
                return null;
            }
        }

        protected ResourceData getResourceData() throws MessagingException, IOException {
            ServletContext servletContext = ServletContextProvider.getServletContext();
            InputStream resourceStream = servletContext.getResourceAsStream(this.imagePath);
            String mimeType = servletContext.getMimeType(this.imagePath);
            return new ResourceData(mimeType, resourceStream);
        }

        @Override
        public String getUniqueName() {
            String name = FilenameUtils.getBaseName((String)this.imagePath);
            UUID uuid = UUID.randomUUID();
            return String.format("static-%s-%s", name, uuid.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageAttachment that = (ImageAttachment)o;
            return this.imagePath.equals(that.imagePath);
        }

        public int hashCode() {
            return this.imagePath.hashCode();
        }

        protected static class ResourceData {
            private final String mimeType;
            private final InputStream inputStream;

            protected ResourceData(String mimeType, InputStream inputStream) {
                this.mimeType = mimeType;
                this.inputStream = inputStream;
            }
        }
    }

    private static interface MailAttachment {
        public BodyPart buildBodyPart();

        public String getUniqueName();
    }
}

