/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.statistics.util.FieldableDocumentHitCollector;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.search.IndexSearcher;

public class FieldHitCollector
extends FieldableDocumentHitCollector {
    private List<String> values = new ArrayList<String>();
    private final String fieldName;
    private final FieldSelector fieldSelector;

    public FieldHitCollector(IndexSearcher searcher, String fieldName) {
        this(fieldName);
    }

    public FieldHitCollector(String fieldName) {
        this.fieldName = Assertions.notBlank((String)"fieldName", (String)fieldName);
        this.fieldSelector = new MapFieldSelector(new String[]{fieldName});
    }

    public void collect(Document d) {
        this.values.add(d.get(this.getFieldName()));
    }

    public List<String> getValues() {
        return this.values;
    }

    private String getFieldName() {
        return this.fieldName;
    }

    protected FieldSelector getFieldSelector() {
        return this.fieldSelector;
    }
}

