/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelAddedEvent;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelDeletedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeAddedToProjectEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeCopiedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeCreatedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeDeletedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeUpdatedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.NameComparator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueSecuritySchemeManagerImpl
extends AbstractSchemeManager
implements IssueSecuritySchemeManager,
Startable {
    private static final Logger log = LoggerFactory.getLogger(IssueSecuritySchemeManagerImpl.class);
    private static final String SCHEME_ENTITY_NAME = "IssueSecurityScheme";
    private static final String ISSUE_SECURITY_ENTITY_NAME = "SchemeIssueSecurities";
    private static final String SCHEME_DESC = "Issue Security";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.security.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.security.default.desc";
    private static final NodeAssocationType ISSUE_SECURITY_SCHEME_ASSOCIATION = new NodeAssocationType("ProjectScheme", "Project", "IssueSecurityScheme");
    private static final int DEFAULT_JIRA_SECURITY_LEVEL_PERMISSIONS_CACHE_MAX_SIZE = 256;
    private final Cache<CacheKey, List<GenericValue>> schemeIdToSecuritiesCache;
    private final Cache<Long, List<IssueSecurityLevelPermission>> securityLevelToPermissionsCache;
    private final ProjectManager projectManager;
    final OfBizDelegator ofBizDelegator;
    private final NodeAssociationStore nodeAssociationStore;

    public IssueSecuritySchemeManagerImpl(ProjectManager projectManager, SecurityTypeManager securityTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, GroupManager groupManager, NodeAssociationStore nodeAssociationStore, CacheManager cacheManager, ApplicationProperties applicationProperties) {
        super(projectManager, securityTypeManager, permissionContextFactory, schemeFactory, nodeAssociationStore, ofBizDelegator, groupManager, eventPublisher, cacheManager);
        this.projectManager = projectManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.ofBizDelegator = ofBizDelegator;
        this.schemeIdToSecuritiesCache = cacheManager.getCache(IssueSecuritySchemeManagerImpl.class.getName() + ".schemeIdToSecuritiesCache", (CacheLoader)new SecuritiesByFieldCacheLoader("scheme"), new CacheSettingsBuilder().maxEntries(64).build());
        int maxEntries = PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.security.level.permission.cache.max.size", (int)256);
        this.securityLevelToPermissionsCache = cacheManager.getCache(IssueSecuritySchemeManagerImpl.class.getName() + "securityLevelToPermissionsCache", (CacheLoader)new PermissionBySecurityLevelCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(maxEntries).build());
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.clearCache();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return ISSUE_SECURITY_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    private void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug("Clearing issue security scheme cache, had " + this.schemeIdToSecuritiesCache.getKeys().size() + " scheme(s) and " + this.securityLevelToPermissionsCache.getKeys().size() + " security level(s)");
        }
        this.schemeIdToSecuritiesCache.removeAll();
        this.securityLevelToPermissionsCache.removeAll();
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) {
        return (List)this.schemeIdToSecuritiesCache.get((Object)new CacheKey(scheme.getLong("id")));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long securityLevelId) throws GenericEntityException {
        List<GenericValue> securities = this.getEntitiesBySecurityLevel(securityLevelId);
        return securities.isEmpty() || scheme.getLong("id").equals(securities.get(0).getLong("scheme")) ? securities : Collections.emptyList();
    }

    public IssueSecurityLevelScheme getIssueSecurityLevelScheme(Long issueSecuritySchemeId) {
        return (IssueSecurityLevelScheme)Select.from(Entity.ISSUE_SECURITY_LEVEL_SCHEME).whereEqual("id", issueSecuritySchemeId).runWith(this.ofBizDelegator).singleValue();
    }

    public Collection<IssueSecurityLevelScheme> getIssueSecurityLevelSchemes() {
        return Select.from(Entity.ISSUE_SECURITY_LEVEL_SCHEME).runWith(this.ofBizDelegator).asList();
    }

    public List<GenericValue> getEntitiesBySecurityLevel(Long securityLevelId) {
        return EntityUtils.convertToGenericValues(Entity.ISSUE_SECURITY_LEVEL_PERMISSION, this.getPermissionsBySecurityLevel(securityLevelId));
    }

    public List<IssueSecurityLevelPermission> getPermissionsBySecurityLevel(Long securityLevelId) {
        return (List)this.securityLevelToPermissionsCache.get((Object)securityLevelId);
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.ofBizDelegator.findByAnd(ISSUE_SECURITY_ENTITY_NAME, (Map)FieldMap.build((String)"type", (Object)type, (String)"parameter", (Object)parameter));
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Long> schemeIds = new HashSet<Long>();
        for (GenericValue schemeEntity : entities) {
            schemeIds.add(schemeEntity.getLong("scheme"));
        }
        return this.getSchemesByIds(schemeIds);
    }

    public void setSchemeForProject(Project project, Long schemeId) {
        this.nodeAssociationStore.removeAssociationsFromSource(ISSUE_SECURITY_SCHEME_ASSOCIATION, project.getId());
        if (schemeId != null) {
            this.nodeAssociationStore.createAssociation(ISSUE_SECURITY_SCHEME_ASSOCIATION, project.getId(), schemeId);
        }
        this.flushProjectSchemes();
    }

    public List<Project> getProjectsUsingScheme(long schemeId) {
        List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(ISSUE_SECURITY_SCHEME_ASSOCIATION, schemeId);
        ArrayList projects = Lists.newArrayListWithCapacity((int)projectIds.size());
        for (Long projectId : projectIds) {
            projects.add(this.projectManager.getProjectObj(projectId));
        }
        Collections.sort(projects, NameComparator.COMPARATOR);
        return projects;
    }

    private Collection<GenericValue> getSchemesByIds(Set<Long> schemeIds) {
        ArrayList<EntityExpr> entityConditions = new ArrayList<EntityExpr>(schemeIds.size());
        for (Long schemeId : schemeIds) {
            entityConditions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)schemeId));
        }
        return entityConditions.isEmpty() ? Collections.emptyList() : this.ofBizDelegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.emptyList());
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long schemeTypeId, String parameter) throws GenericEntityException {
        List<GenericValue> securities = this.getEntities(scheme, schemeTypeId);
        return securities.isEmpty() ? securities : IssueSecuritySchemeManagerImpl.filter(securities, IssueSecuritySchemeManagerImpl.withField("parameter", parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Issue Security scheme IDs must be Long values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long schemeTypeId) throws GenericEntityException {
        List<GenericValue> securities = this.getEntities(scheme, schemeTypeId);
        return securities.isEmpty() ? securities : IssueSecuritySchemeManagerImpl.filter(securities, IssueSecuritySchemeManagerImpl.withField("type", type));
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        GenericValue result = this.createSchemeEntityNoEvent(scheme, schemeEntity);
        this.eventPublisher.publish((Object)new IssueSecurityLevelAddedEvent(scheme == null ? null : scheme.getLong("id"), schemeEntity));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GenericValue createSchemeEntityNoEvent(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof Long)) {
            throw new IllegalArgumentException("Issue Security Level IDs must be a long value.");
        }
        try {
            GenericValue result;
            Long schemeId = scheme == null ? null : scheme.getLong("id");
            GenericValue genericValue = result = EntityUtils.createValue(ISSUE_SECURITY_ENTITY_NAME, (Map<String, Object>)FieldMap.build((String)"scheme", (Object)schemeId, (String)"security", (Object)schemeEntity.getEntityTypeId(), (String)"type", (Object)schemeEntity.getType(), (String)"parameter", (Object)schemeEntity.getParameter()));
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue copyScheme(GenericValue oldScheme) throws GenericEntityException {
        if (oldScheme == null) {
            return null;
        }
        try {
            String name = this.getNameForCopy(oldScheme.getString("name"), null);
            GenericValue newScheme = this.createSchemeNoEvent(name, oldScheme.getString("description"));
            this.copySecurityLevels(newScheme, oldScheme);
            this.eventPublisher.publish((Object)this.createSchemeCopiedEvent(this.schemeFactory.getScheme(oldScheme), this.schemeFactory.getScheme(newScheme)));
            GenericValue genericValue = newScheme;
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    @Nonnull
    protected AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme oldScheme, @Nonnull Scheme newScheme) {
        return new IssueSecuritySchemeCopiedEvent(oldScheme, newScheme);
    }

    private void copySecurityLevels(GenericValue scheme, GenericValue oldScheme) throws GenericEntityException {
        List levels = this.ofBizDelegator.findByAnd("SchemeIssueSecurityLevels", (Map)FieldMap.build((String)"scheme", (Object)oldScheme.getLong("id")));
        for (GenericValue level : levels) {
            IssueSecurityLevel newSecurityLevel = ComponentAccessor.getIssueSecurityLevelManager().createIssueSecurityLevel(scheme.getLong("id").longValue(), level.getString("name"), level.getString("description"));
            if (level.getLong("id").equals(oldScheme.getLong("defaultlevel"))) {
                scheme.set("defaultlevel", (Object)newSecurityLevel.getId());
                scheme.store();
            }
            List securities = this.ofBizDelegator.findByAnd(this.getEntityName(), (Map)FieldMap.build((String)"scheme", (Object)oldScheme.getLong("id"), (String)"security", (Object)level.getLong("id")));
            for (GenericValue security : securities) {
                this.createSchemeEntity(scheme, new SchemeEntity(security.getString("type"), security.getString("parameter"), (Object)newSecurityLevel.getId()));
            }
        }
    }

    public boolean hasSecurityLevelAccess(@Nonnull Issue issue, @Nullable ApplicationUser user) {
        Long securityLevelId = issue.getSecurityLevelId();
        if (securityLevelId == null) {
            return true;
        }
        try {
            Scheme scheme = this.getSchemeFor(issue.getProjectObject());
            if (scheme != null) {
                return this.hasPermission(issue, user, this.getEntities(this.getScheme(scheme.getId()), securityLevelId));
            }
        }
        catch (GenericEntityException e) {
            log.error("Could not retrieve entities from the database", (Throwable)e);
        }
        return false;
    }

    private boolean hasPermission(Issue issue, ApplicationUser user, List<GenericValue> entities) {
        if (entities.isEmpty()) {
            return false;
        }
        for (SecurityType type : this.securityTypeManager.getTypes().values()) {
            for (GenericValue perm : IssueSecuritySchemeManagerImpl.filter(entities, IssueSecuritySchemeManagerImpl.withField("type", type.getType()))) {
                if (perm == null || !this.hasPermission(issue, user, type, perm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPermission(Issue issue, ApplicationUser user, SecurityType type, GenericValue perm) {
        return user == null ? type.hasPermission(issue, perm.getString("parameter")) : type.hasPermission(issue, perm.getString("parameter"), user, false);
    }

    @Override
    protected AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme scheme, Scheme originalScheme) {
        return new IssueSecuritySchemeUpdatedEvent(scheme, originalScheme);
    }

    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        try {
            GenericValue scheme = this.getScheme(id);
            this.nodeAssociationStore.removeAssociationsFromSink(scheme);
            scheme.removeRelated("Child" + this.getEntityName());
            scheme.removeRelated("ChildSchemeIssueSecurityLevels");
            scheme.remove();
            this.eventPublisher.publish((Object)new IssueSecuritySchemeDeletedEvent(id));
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        this.deleteEntities(Collections.singleton(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntities(Iterable<Long> ids) {
        try {
            super.deleteEntities(ids);
            for (Long id : ids) {
                this.eventPublisher.publish((Object)new IssueSecurityLevelDeletedEvent(id));
            }
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    protected SchemeEntity makeSchemeEntity(GenericValue entity) {
        return new SchemeEntity(entity.getString("type"), entity.getString("parameter"), (Object)entity.getLong("security"));
    }

    @Override
    protected Object createSchemeEntityDeletedEvent(GenericValue entity) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    protected AbstractSchemeEvent createSchemeCreatedEvent(Scheme scheme) {
        return new IssueSecuritySchemeCreatedEvent(scheme);
    }

    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        try {
            boolean bl = super.removeEntities(type, parameter);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    protected AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme scheme, Project project) {
        return new IssueSecuritySchemeAddedToProjectEvent(scheme, project);
    }

    @Override
    protected AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme scheme, Project project) {
        return new IssueSecuritySchemeRemovedFromProjectEvent(scheme, project);
    }

    private static List<GenericValue> filter(List<GenericValue> list, Predicate<GenericValue> predicate) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(list, predicate));
    }

    private static Predicate<GenericValue> withField(final String field, final String value) {
        if (value == null) {
            return new Predicate<GenericValue>(){

                public boolean apply(GenericValue input) {
                    return input.getString(field) == null;
                }
            };
        }
        return new Predicate<GenericValue>(){

            public boolean apply(GenericValue input) {
                return value.equals(input.getString(field));
            }
        };
    }

    private final class PermissionBySecurityLevelCacheLoader
    implements CacheLoader<Long, List<IssueSecurityLevelPermission>> {
        private PermissionBySecurityLevelCacheLoader() {
        }

        public List<IssueSecurityLevelPermission> load(@Nullable Long input) {
            return Select.from(Entity.ISSUE_SECURITY_LEVEL_PERMISSION).whereEqual("security", input).runWith(IssueSecuritySchemeManagerImpl.this.ofBizDelegator).asList();
        }
    }

    static class CacheKey
    implements Serializable {
        final Long id;

        CacheKey(Long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.id == null ? other.id == null : this.id.equals(other.id);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }

    class SecuritiesByFieldCacheLoader
    implements CacheLoader<CacheKey, List<GenericValue>> {
        private final String key;

        SecuritiesByFieldCacheLoader(String key) {
            this.key = (String)Assertions.notNull((String)"key", (Object)key);
        }

        public List<GenericValue> load(CacheKey cacheKey) {
            List<GenericValue> result = IssueSecuritySchemeManagerImpl.this.ofBizDelegator.findByAnd(IssueSecuritySchemeManagerImpl.this.getEntityName(), (Map)FieldMap.build((String)this.key, (Object)cacheKey.id));
            return result != null ? result : Collections.emptyList();
        }
    }
}

