/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.fields.ProjectFieldLayoutSchemeHelper;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultProjectFieldLayoutSchemeHelper
implements ProjectFieldLayoutSchemeHelper {
    private final ProjectService projectService;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext authenticationContext;

    public DefaultProjectFieldLayoutSchemeHelper(ProjectService projectService, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext authenticationContext) {
        this.projectService = projectService;
        this.fieldLayoutManager = fieldLayoutManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public List<Project> getProjectsForScheme(Long schemeId) {
        TreeSet matchingProjects = Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
        FieldConfigurationScheme fieldConfigurationScheme = this.fieldLayoutManager.getFieldConfigurationScheme(schemeId);
        for (Project project : this.getProjectsForUser(this.authenticationContext.getUser())) {
            FieldConfigurationScheme projectScheme = this.fieldLayoutManager.getFieldConfigurationScheme(project);
            if ((!this.isSystemDefaultScheme(fieldConfigurationScheme) || !this.isSystemDefaultScheme(projectScheme)) && (fieldConfigurationScheme == null || projectScheme == null || !fieldConfigurationScheme.getId().equals(projectScheme.getId()))) continue;
            matchingProjects.add(project);
        }
        return Lists.newArrayList((Iterable)matchingProjects);
    }

    @Override
    public Multimap<FieldLayout, Project> getProjectsForFieldLayouts(Set<FieldLayout> fieldLayouts) {
        HashMap backingMap = Maps.newHashMap();
        SetMultimap fieldLayoutMultimap = Multimaps.newSetMultimap((Map)backingMap, (Supplier)new Supplier<Set<Project>>(){

            public Set<Project> get() {
                return Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
            }
        });
        List<Project> projectsForUser = this.getProjectsForUser(this.authenticationContext.getUser());
        for (Project project : projectsForUser) {
            for (IssueType issueType : project.getIssueTypes()) {
                FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, issueType.getId());
                if (!fieldLayouts.contains(fieldLayout)) continue;
                fieldLayoutMultimap.put((Object)fieldLayout, (Object)project);
            }
        }
        return fieldLayoutMultimap;
    }

    @Override
    public List<Project> getProjectsForFieldLayout(FieldLayout fieldLayout) {
        Multimap<FieldLayout, Project> projectsForFieldLayouts = this.getProjectsForFieldLayouts(Collections.singleton(fieldLayout));
        return Lists.newArrayList((Iterable)projectsForFieldLayouts.get((Object)fieldLayout));
    }

    private boolean isSystemDefaultScheme(FieldConfigurationScheme fieldConfigurationScheme) {
        return fieldConfigurationScheme == null || fieldConfigurationScheme.getId() == null;
    }

    private List<Project> getProjectsForUser(ApplicationUser user) {
        ServiceOutcome allProjectsForAction = this.projectService.getAllProjectsForAction(user, ProjectAction.EDIT_PROJECT_CONFIG);
        if (allProjectsForAction.isValid()) {
            return (List)allProjectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }
}

