/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.util.map.CacheObject;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@EventComponent
public class CachedGenericConfigManager
implements GenericConfigManager {
    private final GenericConfigManager delegate;
    private final Cache<Key, CacheObject<Object>> cache;

    public CachedGenericConfigManager(GenericConfigManager delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.cache = cacheManager.getCache(CachedGenericConfigManager.class.getName() + ".cache", (CacheLoader)new GeneralConfigCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    public void create(String dataType, String key, @Nullable Object obj) {
        this.delegate.create(dataType, key, obj);
        this.cache.remove((Object)new Key(dataType, key));
    }

    public void update(String dataType, String key, @Nullable Object obj) {
        this.delegate.update(dataType, key, obj);
        this.cache.remove((Object)new Key(dataType, key));
    }

    public Object retrieve(String dataType, String key) {
        return ((CacheObject)this.cache.get((Object)new Key(dataType, key))).getValue();
    }

    public void remove(String dataType, String key) {
        this.delegate.remove(dataType, key);
        this.cache.remove((Object)new Key(dataType, key));
    }

    private class GeneralConfigCacheLoader
    implements CacheLoader<Key, CacheObject<Object>> {
        private GeneralConfigCacheLoader() {
        }

        public CacheObject<Object> load(@Nonnull Key key) {
            return CacheObject.wrap(CachedGenericConfigManager.this.delegate.retrieve(key.dataType, key.key));
        }
    }

    private static class Key
    implements Serializable {
        final String dataType;
        final String key;
        transient int hashCode;

        Key(String dataType, String key) {
            this.dataType = dataType;
            this.key = key;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int PRIME = 31;
                int result = 1;
                result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
                this.hashCode = result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

