/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store;

import com.atlassian.fugue.Option;
import com.atlassian.jira.util.PathTraversalRuntimeException;
import com.atlassian.jira.util.PathUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTraversalChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathTraversalChecker.class);

    public Option<Exception> validateFileInSecureDirectory(File untrustedFile, File secureDirectory) {
        try {
            boolean pathInSecureDir = PathUtils.isPathInSecureDir((File)secureDirectory, (File)untrustedFile);
            if (pathInSecureDir) {
                return Option.none();
            }
            LOGGER.warn("Detected PathTraversal attack attempt! SecureDirectory: [ {} ]  UntrustedFile: [ {} ]", (Object)secureDirectory.getAbsolutePath(), (Object)untrustedFile.getAbsolutePath());
            return Option.some((Object)new PathTraversalRuntimeException());
        }
        catch (Exception exception) {
            return Option.some((Object)exception);
        }
    }
}

