/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.instrumentation.CachedExternalValue;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import java.util.concurrent.TimeUnit;

public class DomainObjectsExternalGauges {
    public DomainObjectsExternalGauges() {
        this.newExternalGauge(InstrumentationName.TOTAL_ISSUES, (ExternalValue)new OfBizViewExternalValue("Issue"));
        this.newExternalGauge(InstrumentationName.TOTAL_PROJECTS, (ExternalValue)new OfBizViewExternalValue("Project"));
        this.newExternalGauge(InstrumentationName.TOTAL_CUSTOMFIELDS, (ExternalValue)new OfBizViewExternalValue("CustomField"));
        this.newExternalGauge(InstrumentationName.TOTAL_WORKFLOWS, (ExternalValue)new OfBizViewExternalValue("Workflow"));
        this.newExternalGauge(InstrumentationName.TOTAL_USERS, (ExternalValue)new OfBizViewExternalValue("OSUser"));
        this.newExternalGauge(InstrumentationName.TOTAL_GROUPS, (ExternalValue)new OfBizViewExternalValue("OSGroup"));
    }

    private Instrument newExternalGauge(InstrumentationName name, ExternalValue externalValue) {
        ExternalGauge externalGauge = new ExternalGauge(name.getInstrumentName(), externalValue);
        Instrumentation.putInstrument((Instrument)externalGauge);
        return externalGauge;
    }

    private static class OfBizViewExternalValue
    extends CachedExternalValue {
        private final String entityName;

        private OfBizViewExternalValue(String entityName) {
            super(120L, TimeUnit.SECONDS);
            this.entityName = entityName;
        }

        protected long computeValue() {
            try {
                return ComponentAccessor.getOfBizDelegator().getCount(this.entityName);
            }
            catch (DataAccessException e) {
                return -1L;
            }
        }
    }
}

