/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.util.RuntimeInterruptedException;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Timeout;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

final class FutureResult
implements Index.Result {
    private final Future<Index.Result> future;

    public FutureResult(@Nonnull Future<Index.Result> future) {
        this.future = (Future)Assertions.notNull((String)"future", future);
    }

    @Override
    public void await() {
        try {
            this.future.get().await();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
    }

    @Override
    public boolean await(long time, TimeUnit unit) {
        Timeout timeout = Timeout.getNanosTimeout((long)time, (TimeUnit)unit);
        try {
            return this.future.get(timeout.getTime(), timeout.getUnit()).await(timeout.getTime(), timeout.getUnit());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }
}

