/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;

class DelegateSearcher
extends IndexSearcher
implements Supplier<IndexSearcher> {
    private final IndexSearcher searcher;

    DelegateSearcher(IndexSearcher searcher) {
        super(searcher.getIndexReader());
        this.searcher = (IndexSearcher)Assertions.notNull((String)"searcher", (Object)searcher);
    }

    public IndexSearcher get() {
        return this.searcher;
    }

    public IndexReader getIndexReader() {
        return this.searcher.getIndexReader();
    }

    protected void gatherSubReaders(List<IndexReader> allSubReaders, IndexReader r) {
        super.gatherSubReaders(allSubReaders, r);
    }

    public IndexReader[] getSubReaders() {
        return this.searcher.getSubReaders();
    }

    protected TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort, boolean fillFields) throws IOException {
        throw new UnsupportedOperationException("We Cannot delegate this protected method.");
    }

    public void setDefaultFieldSortScoring(boolean doTrackScores, boolean doMaxScore) {
        this.searcher.setDefaultFieldSortScoring(doTrackScores, doMaxScore);
    }

    public void close() throws IOException {
        this.searcher.close();
    }

    public Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.searcher.doc(n, fieldSelector);
    }

    public Document doc(int i) throws CorruptIndexException, IOException {
        return this.searcher.doc(i);
    }

    public int docFreq(Term term) throws IOException {
        return this.searcher.docFreq(term);
    }

    public int[] docFreqs(Term[] terms) throws IOException {
        return this.searcher.docFreqs(terms);
    }

    public boolean equals(Object obj) {
        return this.searcher.equals(obj);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.searcher.explain(query, doc);
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        return this.searcher.explain(weight, doc);
    }

    public Similarity getSimilarity() {
        return this.searcher.getSimilarity();
    }

    public int hashCode() {
        return this.searcher.hashCode();
    }

    public int maxDoc() {
        return this.searcher.maxDoc();
    }

    public Query rewrite(Query query) throws IOException {
        return this.searcher.rewrite(query);
    }

    public void search(Query query, Filter filter, Collector results) throws IOException {
        this.searcher.search(query, filter, results);
    }

    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        return this.searcher.search(query, n, sort);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.searcher.search(query, filter, n, sort);
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.searcher.search(query, n);
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.searcher.search(query, filter, n);
    }

    public void search(Query query, Collector results) throws IOException {
        this.searcher.search(query, results);
    }

    public void search(Weight weight, Filter filter, Collector results) throws IOException {
        this.searcher.search(weight, filter, results);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        return this.searcher.search(weight, filter, n, sort);
    }

    public TopDocs search(Weight weight, Filter filter, int n) throws IOException {
        return this.searcher.search(weight, filter, n);
    }

    public void setSimilarity(Similarity similarity) {
        this.searcher.setSimilarity(similarity);
    }

    public String toString() {
        return this.searcher.toString();
    }
}

