/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.listeners.mail.IssueEventBundleMailHandler;
import com.atlassian.jira.event.listeners.mail.IssueEventMailNotifier;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeEntity;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueEventBundleMailHandlerImpl
implements IssueEventBundleMailHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueEventBundleMailHandlerImpl.class);
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueEventMailNotifier mailNotifier;

    public IssueEventBundleMailHandlerImpl(NotificationSchemeManager notificationSchemeManager, IssueEventMailNotifier mailNotifier) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.mailNotifier = mailNotifier;
    }

    @Override
    public void handle(@Nonnull IssueEventBundle issueEventBundle) {
        if (!issueEventBundle.doesSendEmailNotification()) {
            return;
        }
        HashSet<NotificationRecipient> recipientsAlreadyNotified = new HashSet<NotificationRecipient>();
        for (JiraIssueEvent event : issueEventBundle.getEvents()) {
            if (!(event instanceof DelegatingJiraIssueEvent)) continue;
            IssueEvent issueEvent = ((DelegatingJiraIssueEvent)event).asIssueEvent();
            if (!issueEvent.isSendMail()) {
                log.debug("Not sending email for event " + issueEvent);
                continue;
            }
            List<SchemeEntity> schemeEntities = this.getSchemeEntities(issueEvent.getProject(), issueEvent);
            Set<NotificationRecipient> recipientsNotifiedForEvent = this.mailNotifier.generateNotifications(schemeEntities, issueEvent, (Set<NotificationRecipient>)ImmutableSet.copyOf(recipientsAlreadyNotified));
            recipientsAlreadyNotified.addAll(recipientsNotifiedForEvent);
        }
    }

    @Nonnull
    private List<SchemeEntity> getSchemeEntities(@Nonnull Project project, @Nonnull IssueEvent event) {
        try {
            return this.notificationSchemeManager.getNotificationSchemeEntities(project, event.getEventTypeId().longValue());
        }
        catch (GenericEntityException e) {
            log.error("There was an error accessing the notification scheme for the project: " + project.getKey() + ".", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

