/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.remotelink;

import com.atlassian.jira.entity.remotelink.LazyJsonParser;
import com.atlassian.jira.entity.remotelink.RemoteEntityLink;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;

public abstract class RemoteEntityLinkImpl<E>
implements RemoteEntityLink<E> {
    protected static final String APPLICATION = "application";
    protected static final String APPLICATION_NAME = "name";
    protected static final String APPLICATION_TYPE = "type";
    protected static final String OBJECT = "object";
    protected static final String OBJECT_ICON = "icon";
    protected static final String OBJECT_ICON_TITLE = "title";
    protected static final String OBJECT_ICON_URL = "url16x16";
    protected static final String OBJECT_SUMMARY = "summary";
    protected static final String OBJECT_TITLE = "title";
    protected static final String OBJECT_URL = "url";
    protected final String globalId;
    protected final LazyJsonParser jsonRef;

    protected RemoteEntityLinkImpl(@Nonnull String globalId, @Nonnull String json) {
        this.globalId = Assertions.notBlank((String)"globalId", (String)globalId);
        this.jsonRef = new LazyJsonParser((String)Assertions.notNull((String)"json", (Object)json));
    }

    @Nonnull
    public String getGlobalId() {
        return this.globalId;
    }

    @Nonnull
    public String getJsonString() {
        return this.jsonRef.getJson();
    }

    public String getTitle() {
        return this.jsonRef.getTextAtPath(OBJECT, "title");
    }

    public String getSummary() {
        return this.jsonRef.getTextAtPath(OBJECT, OBJECT_SUMMARY);
    }

    public String getUrl() {
        return this.jsonRef.getTextAtPath(OBJECT, OBJECT_URL);
    }

    public String getIconUrl() {
        return this.jsonRef.getTextAtPath(OBJECT, OBJECT_ICON, OBJECT_ICON_URL);
    }

    public String getIconTitle() {
        return this.jsonRef.getTextAtPath(OBJECT, OBJECT_ICON, "title");
    }

    public String getApplicationName() {
        return this.jsonRef.getTextAtPath(APPLICATION, APPLICATION_NAME);
    }

    public String getApplicationType() {
        return this.jsonRef.getTextAtPath(APPLICATION, APPLICATION_TYPE);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

