/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.DatabaseSystemTimeReader;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class SqlStoredProcedureTimeReader
implements DatabaseSystemTimeReader {
    private final OfBizConnectionFactory connectionFactory = DefaultOfBizConnectionFactory.getInstance();
    private final String code;

    public SqlStoredProcedureTimeReader(@Nonnull String code) {
        this.code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDatabaseSystemTimeMillis() throws SQLException {
        Connection con = this.connectionFactory.getConnection();
        try {
            long l;
            CallableStatement stat = con.prepareCall(this.code);
            try {
                stat.registerOutParameter(1, 2);
                stat.execute();
                l = stat.getLong(1);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeQuietly(stat);
                throw throwable;
            }
            DatabaseUtil.closeQuietly(stat);
            return l;
        }
        finally {
            DatabaseUtil.closeQuietly(con);
        }
    }
}

