/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.monitor;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.ManagedCache;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cache.monitor.CacheStatisticsAnalyticEvent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStatisticsMonitor
implements Startable,
JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CacheStatisticsMonitor.class);
    private static final long DAILY = TimeUnit.DAYS.toMillis(1L);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)CacheStatisticsMonitor.class.getName());
    private static final JobId JOB_ID = JobId.of((String)CacheStatisticsMonitor.class.getName());
    private static final long FOUR_HOURS = Duration.ofHours(4L).toMillis();
    private final CacheManager cacheManager;
    private final EventPublisher eventPublisher;
    private final Random random;

    public CacheStatisticsMonitor(CacheManager cacheManager, EventPublisher eventPublisher) {
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
        this.random = new Random(Runtime.getRuntime().freeMemory());
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            List<CacheStatisticsAnalyticEvent> cacheStatistics = this.getCacheStatistics();
            this.sendToAnalytics(cacheStatistics);
        }
        catch (Exception ex) {
            LOG.warn("Exception occurred when running " + JOB_RUNNER_KEY + " job.", (Throwable)ex);
            return JobRunnerResponse.failed((Throwable)ex);
        }
        return JobRunnerResponse.success();
    }

    public void start() throws Exception {
        SchedulerService scheduler = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        scheduler.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        Date firstRun = Date.from(Instant.now().plusMillis(this.random.nextLong() % FOUR_HOURS));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)DAILY, (Date)firstRun));
        scheduler.scheduleJob(JOB_ID, jobConfig);
    }

    private List<CacheStatisticsAnalyticEvent> getCacheStatistics() {
        return this.cacheManager.getManagedCaches().stream().map(cache -> new CacheStatisticsAnalyticEvent(cache.getName(), this.calculateStatistics((ManagedCache)cache))).collect(Collectors.toList());
    }

    private Map<CacheStatisticsKey, Long> calculateStatistics(ManagedCache cache) {
        HashMap stats = Maps.newHashMap();
        for (Map.Entry entry : cache.getStatistics().entrySet()) {
            stats.put(entry.getKey(), ((Supplier)entry.getValue()).get());
        }
        return stats;
    }

    private void sendToAnalytics(List<CacheStatisticsAnalyticEvent> stats) {
        stats.stream().forEach(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
    }
}

