/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import org.apache.commons.lang.StringUtils;

public class UserMatcherPredicate
implements Predicate<ApplicationUser> {
    private final String query;
    private final boolean canMatchAddresses;
    private final String emailQuery;

    public UserMatcherPredicate(String query, boolean canMatchAddresses) {
        this(query, "", canMatchAddresses);
    }

    public UserMatcherPredicate(String nameQuery, String emailQuery, boolean canMatchAddresses) {
        Assertions.notNull((String)"query", (Object)nameQuery);
        Assertions.notNull((String)"emailquery", (Object)emailQuery);
        this.query = nameQuery.toLowerCase();
        this.emailQuery = emailQuery == null ? null : emailQuery.toLowerCase();
        this.canMatchAddresses = canMatchAddresses;
    }

    public boolean apply(ApplicationUser user) {
        boolean separateEmailQuery = StringUtils.isNotBlank((String)this.emailQuery);
        boolean usernameMatched = false;
        String userPart = user.getName();
        if (StringUtils.isNotBlank((String)userPart) && this.startsWithCaseInsensitive(userPart, this.query)) {
            if (separateEmailQuery && this.canMatchAddresses) {
                usernameMatched = true;
            } else {
                return true;
            }
        }
        if (this.canMatchAddresses) {
            userPart = user.getEmailAddress();
            if (StringUtils.isNotBlank((String)userPart) && this.startsWithCaseInsensitive(userPart, separateEmailQuery ? this.emailQuery : this.query)) {
                if (!separateEmailQuery || usernameMatched) {
                    return true;
                }
            } else if (separateEmailQuery) {
                return false;
            }
        }
        if (StringUtils.isNotBlank((String)(userPart = user.getDisplayName()))) {
            if (this.startsWithCaseInsensitive(userPart, this.query)) {
                return true;
            }
            String[] tokens = StringUtils.split((String)userPart, (char)' ');
            for (int i = 1; i < tokens.length; ++i) {
                String token = tokens[i];
                if (!this.startsWithCaseInsensitive(token, this.query)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean startsWithCaseInsensitive(String userPart, String query) {
        if (query.length() == 0) {
            return true;
        }
        if (query.length() > userPart.length()) {
            return false;
        }
        if (userPart.substring(0, 1).toLowerCase().charAt(0) == query.charAt(0)) {
            return userPart.substring(0, query.length()).toLowerCase().equals(query);
        }
        return false;
    }
}

