/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IteratedSearcher {
    private int maxResultsPerQuery = 10000;
    private double initialLimitFactor = 2.0;

    public <T> List<T> iteratedSearch(Source<T> source, Predicate<? super T> filter, int limit) {
        int numFilteredResults;
        ArrayList<Object> allFilteredResults = new ArrayList<Object>(limit);
        boolean atEndOfResults = false;
        int currentOffset = 0;
        int currentLimit = Predicates.alwaysTrue().equals(filter) ? limit : (int)((double)limit * this.initialLimitFactor);
        for (int resultCount = 0; !atEndOfResults && resultCount < limit; resultCount += numFilteredResults) {
            int remaining = limit - resultCount;
            List<Object> curResults = source.search(currentOffset, currentLimit);
            int numUnfilteredResults = curResults.size();
            currentOffset += numUnfilteredResults;
            atEndOfResults = numUnfilteredResults < currentLimit;
            curResults = this.filterList(curResults, filter);
            numFilteredResults = curResults.size();
            allFilteredResults.addAll(curResults.subList(0, Math.min(remaining, numFilteredResults)));
            double filterFactor = numFilteredResults == 0 ? 1.0 / (double)numUnfilteredResults : (double)numFilteredResults / (double)numUnfilteredResults;
            currentLimit = (int)((double)currentLimit / filterFactor);
            currentLimit = Math.min(this.maxResultsPerQuery, currentLimit);
        }
        return allFilteredResults;
    }

    private <T> List<T> filterList(List<T> unfiltered, Predicate<? super T> filter) {
        return ImmutableList.copyOf((Collection)Collections2.filter(unfiltered, filter));
    }

    public static interface Source<T> {
        public List<T> search(int var1, int var2);
    }
}

