/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.project.version.ValidationResultImpl;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collections;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeleteVersionValidator {
    private static final Logger log = LoggerFactory.getLogger(DeleteVersionValidator.class);
    private final JiraServiceContext context;
    private final VersionManager versionManager;
    private final PermissionManager permissionManager;

    DeleteVersionValidator(JiraServiceContext context, VersionManager versionManager, PermissionManager permissionManager) {
        Null.not("context", context);
        Null.not("versionManager", versionManager);
        Null.not("permissionManager", permissionManager);
        this.context = context;
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
    }

    VersionService.ValidationResult validate(Long versionId, VersionService.VersionAction affectsAction, VersionService.VersionAction fixAction) {
        Version versionToDelete;
        Null.not("affectsAction", affectsAction);
        Null.not("fixAction", fixAction);
        Long affectsSwapVersionId = affectsAction.getSwapVersionId();
        Long fixSwapVersionId = fixAction.getSwapVersionId();
        if (log.isDebugEnabled()) {
            log.debug("Validating Version action - id to delete: " + versionId + ", affectsAction: " + affectsAction + ", fixAction: " + fixAction);
        }
        if ((versionToDelete = this.validateAndGetVersion(versionId, "admin.manageversions.noversionspecified", "admin.manageversions.noversionwithid")) == null) {
            log.debug("Version id: " + versionId + " was not valid");
            return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, null, null, false, EnumSet.of(VersionService.ValidationResult.Reason.NOT_FOUND));
        }
        if (!this.checkProjectAdminPermission(versionToDelete.getProject())) {
            if (log.isDebugEnabled()) {
                log.debug("User '" + this.context.getLoggedInUser() + "' did not have permission to delete this version");
            }
            return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, null, null, false, EnumSet.of(VersionService.ValidationResult.Reason.FORBIDDEN));
        }
        Version affectsSwapVersion = null;
        if (affectsAction.isSwap()) {
            affectsSwapVersion = this.validateAndGetVersion(affectsSwapVersionId, "admin.manageversions.noversionspecified.for.affects", "admin.manageversions.noversionwithid.for.affects");
            if (affectsSwapVersion == null) {
                log.debug("Affects swap version id: " + affectsSwapVersionId + " was not valid");
                return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, null, null, false, EnumSet.of(VersionService.ValidationResult.Reason.SWAP_TO_VERSION_INVALID));
            }
            if (versionId.equals(affectsSwapVersionId)) {
                log.debug("Affects swap version id same as version to delete");
                this.addErrorMessage("admin.manageversions.cannot.swap.to.delete.version");
                return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, affectsSwapVersion, null, false, EnumSet.of(VersionService.ValidationResult.Reason.SWAP_TO_VERSION_INVALID));
            }
            if (!versionToDelete.getProjectId().equals(affectsSwapVersion.getProjectId())) {
                log.debug("Affects swap version id not in same project as version to delete");
                this.addErrorMessage("admin.manageversions.cannot.move.to.different.project.version");
                return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, affectsSwapVersion, null, false, EnumSet.of(VersionService.ValidationResult.Reason.SWAP_TO_VERSION_INVALID));
            }
        }
        Version fixSwapVersion = null;
        if (fixAction.isSwap()) {
            fixSwapVersion = this.validateAndGetVersion(fixSwapVersionId, "admin.manageversions.noversionspecified.for.fix", "admin.manageversions.noversionwithid.for.fix");
            if (fixSwapVersion == null) {
                log.debug("Fix swap version id: " + fixSwapVersionId + " was not valid");
                return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, affectsSwapVersion, null, false, EnumSet.of(VersionService.ValidationResult.Reason.SWAP_TO_VERSION_INVALID));
            }
            if (versionId.equals(fixSwapVersionId)) {
                log.debug("Fix swap version id same as version to delete");
                this.addErrorMessage("admin.manageversions.cannot.swap.to.delete.version");
                return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, affectsSwapVersion, fixSwapVersion, false, EnumSet.of(VersionService.ValidationResult.Reason.SWAP_TO_VERSION_INVALID));
            }
            if (!versionToDelete.getProject().getId().equals(fixSwapVersion.getProject().getId())) {
                log.debug("Fix swap version id not in same project as version to delete");
                this.addErrorMessage("admin.manageversions.cannot.move.to.different.project.version");
                return new ValidationResultImpl(this.context.getErrorCollection(), versionToDelete, affectsSwapVersion, fixSwapVersion, false, EnumSet.of(VersionService.ValidationResult.Reason.SWAP_TO_VERSION_INVALID));
            }
        }
        return new ValidationResultImpl((ErrorCollection)new SimpleErrorCollection(), versionToDelete, affectsSwapVersion, fixSwapVersion, true, Collections.emptySet());
    }

    private Version validateAndGetVersion(Long versionId, String keyForNull, String keyForBadId) {
        if (versionId == null) {
            this.addErrorMessage(keyForNull);
            return null;
        }
        Version version = this.versionManager.getVersion(versionId);
        if (version == null) {
            this.addErrorMessage(keyForBadId, versionId.toString());
        }
        return version;
    }

    private boolean checkProjectAdminPermission(Project project) {
        boolean hasProjectAdminPermission;
        ApplicationUser user = this.context.getLoggedInApplicationUser();
        boolean bl = hasProjectAdminPermission = this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
        if (!hasProjectAdminPermission) {
            if (user != null) {
                this.addErrorMessage("admin.manageversions.usernopermission.withuser", user.getName());
            } else {
                this.addErrorMessage("admin.manageversions.usernopermission");
            }
        }
        return hasProjectAdminPermission;
    }

    private void addErrorMessage(String key) {
        this.context.getErrorCollection().addErrorMessage(this.context.getI18nBean().getText(key));
    }

    private void addErrorMessage(String key, String value1) {
        this.context.getErrorCollection().addErrorMessage(this.context.getI18nBean().getText(key, value1));
    }
}

