/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectNameValidator;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.ProjectTypeValidator;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.project.ProjectEventManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectCreateNotifier;
import com.atlassian.jira.project.ProjectCreatedData;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.template.ProjectTemplateManager;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeUpdatedNotifier;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectService
implements ProjectService {
    private static final int MAX_FIELD_LENGTH = 255;
    private static final int DEFAULT_KEY_LENGTH = 10;
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectService.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SchemeFactory schemeFactory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final VersionManager versionManager;
    private final ProjectComponentManager projectComponentManager;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private final AvatarManager avatarManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final WorkflowManager workflowManager;
    private final UserManager userManager;
    private final ProjectEventManager projectEventManager;
    private final ProjectKeyStore projectKeyStore;
    private final ProjectNameValidator projectNameValidator;
    private final ProjectTypeValidator projectTypeValidator;
    private final ProjectTypeUpdatedNotifier projectTypeUpdatedNotifier;
    private final ProjectCreateNotifier projectCreateNotifier;
    private final ClusterLockService clusterLockService;
    private final ProjectTemplateManager projectTemplateManager;

    public DefaultProjectService(JiraAuthenticationContext jiraAuthenticationContext, ProjectManager projectManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, PermissionSchemeManager permissionSchemeManager, NotificationSchemeManager notificationSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SchemeFactory schemeFactory, WorkflowSchemeManager workflowSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, CustomFieldManager customFieldManager, NodeAssociationStore nodeAssociationStore, VersionManager versionManager, ProjectComponentManager projectComponentManager, SharePermissionDeleteUtils sharePermissionDeleteUtils, AvatarManager avatarManager, I18nHelper.BeanFactory i18nFactory, WorkflowManager workflowManager, UserManager userManager, ProjectEventManager projectEventManager, ProjectKeyStore projectKeyStore, ProjectTypeValidator projectTypeValidator, ProjectCreateNotifier projectCreateNotifier, ProjectTypeUpdatedNotifier projectTypeUpdatedNotifier, ClusterLockService clusterLockService, ProjectTemplateManager projectTemplateManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.schemeFactory = schemeFactory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.customFieldManager = customFieldManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.versionManager = versionManager;
        this.projectComponentManager = projectComponentManager;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.avatarManager = avatarManager;
        this.i18nFactory = i18nFactory;
        this.workflowManager = workflowManager;
        this.userManager = userManager;
        this.projectEventManager = projectEventManager;
        this.projectKeyStore = projectKeyStore;
        this.projectTypeValidator = projectTypeValidator;
        this.projectCreateNotifier = projectCreateNotifier;
        this.projectTypeUpdatedNotifier = projectTypeUpdatedNotifier;
        this.clusterLockService = clusterLockService;
        this.projectTemplateManager = projectTemplateManager;
        this.projectNameValidator = new ProjectNameValidator(this, projectManager);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType) {
        return this.validateUpdateProject(user, name, key, description, this.nameFor(lead), url, assigneeType);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(user, name, key, description, this.nameFor(lead), url, assigneeType, avatarId);
    }

    public ProjectService.DeleteProjectValidationResult validateDeleteProject(ApplicationUser user, String key) {
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return new ProjectService.DeleteProjectValidationResult(ErrorCollections.create((String)i18nBean.getText("admin.projects.service.error.no.admin.permission"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
        }
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            return new ProjectService.DeleteProjectValidationResult(ErrorCollections.copyOf((ErrorCollection)oldProjectResult.getErrorCollection()));
        }
        return new ProjectService.DeleteProjectValidationResult(ErrorCollections.empty(), oldProjectResult.getProject());
    }

    public ProjectService.DeleteProjectResult deleteProject(ApplicationUser user, ProjectService.DeleteProjectValidationResult result) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        JiraServiceContext serviceContext = this.getServiceContext(user, errorCollection);
        I18nHelper i18nBean = this.getI18nBean(user);
        if (result == null) {
            throw new IllegalArgumentException("You can not delete a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not delete a project with an invalid validation result.");
        }
        Project project = result.getProject();
        try {
            this.projectManager.removeProjectIssues(project);
        }
        catch (RemoveException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult(errorCollection);
        }
        this.customFieldManager.removeProjectAssociations(project);
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project);
        this.issueTypeScreenSchemeManager.removeSchemeAssociation(project, issueTypeScreenScheme);
        Scheme workflowScheme = this.workflowSchemeManager.getSchemeFor(project);
        Iterable workflowsAssociatedToProject = this.workflowManager.getWorkflowsFromScheme(workflowScheme);
        try {
            this.nodeAssociationStore.removeAllAssociationsFromSource("Project", project.getId());
            List allVersions = this.versionManager.getVersions(project.getId());
            for (Version version : allVersions) {
                this.versionManager.deleteVersion(version);
            }
            Collection components = this.projectComponentManager.findAllForProject(project.getId());
            for (ProjectComponent component : components) {
                this.projectComponentManager.delete(component.getId());
            }
        }
        catch (DataAccessException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult(errorCollection);
        }
        catch (EntityNotFoundException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult(errorCollection);
        }
        this.sharePermissionDeleteUtils.deleteProjectSharePermissions(project.getId());
        this.workflowSchemeManager.cleanUpSchemeDraft(project, user);
        this.projectManager.removeProject(project);
        this.projectManager.refresh();
        this.workflowSchemeManager.clearWorkflowCache();
        this.workflowManager.copyAndDeleteDraftsForInactiveWorkflowsIn(user, workflowsAssociatedToProject);
        this.projectEventManager.dispatchProjectDeleted(user, project);
        return new ProjectService.DeleteProjectResult(errorCollection);
    }

    public ProjectService.GetProjectResult getProjectById(Long id) {
        return this.getProjectById(this.jiraAuthenticationContext.getUser(), id);
    }

    public ProjectService.GetProjectResult getProjectByKey(String key) {
        return this.getProjectByKey(this.jiraAuthenticationContext.getUser(), key);
    }

    @Nonnull
    public ProjectService.CreateProjectValidationResult validateCreateProject(ApplicationUser user, @Nonnull ProjectCreationData projectCreationData) {
        JiraServiceContext serviceContext = this.getServiceContext(user, ErrorCollections.empty());
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            serviceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"), ErrorCollection.Reason.FORBIDDEN);
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        ProjectCreationData overridenProjectCreationData = this.overrideProjectTypeUsingTypeFromProjectTemplate(projectCreationData);
        this.isValidAllProjectData(serviceContext, overridenProjectCreationData);
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection(), user, overridenProjectCreationData);
    }

    private ProjectCreationData overrideProjectTypeUsingTypeFromProjectTemplate(ProjectCreationData projectCreationData) {
        return Optional.ofNullable(projectCreationData.getProjectTemplateKey()).flatMap(arg_0 -> ((ProjectTemplateManager)this.projectTemplateManager).getProjectTemplate(arg_0)).map(template -> new ProjectCreationData.Builder().from(projectCreationData).withType(template.getProjectTypeKey()).build()).orElseGet(() -> projectCreationData);
    }

    protected JiraServiceContext getServiceContext(ApplicationUser user, ErrorCollection errorCollection) {
        return new JiraServiceContextImpl(user, errorCollection);
    }

    public Project createProject(ProjectService.CreateProjectValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not create a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not create a project with an invalid validation result.");
        }
        ProjectCreationData projectCreationData = result.getProjectCreationData();
        ApplicationUser user = result.getUser();
        Project newProject = this.projectManager.createProject(user, new ProjectCreationData.Builder().from(projectCreationData).withKey(projectCreationData.getKey().toUpperCase()).withLead(projectCreationData.getLead()).withAssigneeType(this.effectiveAssigneeType(projectCreationData.getAssigneeType())).build());
        this.associateWithDefaultSchemes(newProject);
        this.workflowSchemeManager.clearWorkflowCache();
        this.notifyHandlersOfProjectCreated(user, newProject, projectCreationData.getProjectTemplateKey());
        this.projectEventManager.dispatchProjectCreated(user, newProject);
        return newProject;
    }

    private void notifyHandlersOfProjectCreated(ApplicationUser user, Project newProject, ProjectTemplateKey projectTemplateKey) {
        ProjectCreatedData projectCreatedData = new ProjectCreatedData.Builder().withProject(newProject).withProjectTemplateKey(projectTemplateKey).build();
        boolean notificationWasSuccessful = this.projectCreateNotifier.notifyAllHandlers(projectCreatedData);
        if (!notificationWasSuccessful) {
            this.deleteProject(user, new ProjectService.DeleteProjectValidationResult(ErrorCollections.empty(), newProject));
            throw new RuntimeException("An error occurred while notifying that a project was created");
        }
    }

    private void associateWithDefaultSchemes(Project newProject) {
        this.issueTypeScreenSchemeManager.associateWithDefaultScheme(newProject);
        this.notificationSchemeManager.addDefaultSchemeToProject(newProject);
        this.permissionSchemeManager.addDefaultSchemeToProject(newProject);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, String leadName, String url, Long assigneeType) {
        return this.validateUpdateProject(user, name, key, description, leadName, url, assigneeType, null);
    }

    public ServiceResult validateUpdateProject(ApplicationUser user, String key) {
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            return new ServiceResultImpl(ErrorCollections.copyOf((ErrorCollection)oldProjectResult.getErrorCollection()));
        }
        return new ServiceResultImpl(ErrorCollections.empty());
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser applicationUser, Project originalProject, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(applicationUser, originalProject, name, key, description, this.nameFor(lead), url, assigneeType, avatarId);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser applicationUser, Project originalProject, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(applicationUser, name, originalProject.getKey(), key, description, leadName, url, assigneeType, avatarId);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(user, name, key, key, description, leadName, url, assigneeType, avatarId);
    }

    private ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String oldKey, String newKey, String description, String leadName, String url, Long assigneeType, Long avatarId) {
        ApplicationUser lead;
        ErrorCollection validationErrors;
        I18nHelper i18nBean = this.getI18nBean(user);
        ProjectService.GetProjectResult getProjectResult = this.getProjectByKeyForAction(user, oldKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!getProjectResult.isValid() || getProjectResult.getProject() == null) {
            return new ProjectService.UpdateProjectValidationResult(ErrorCollections.copyOf((ErrorCollection)getProjectResult.getErrorCollection()));
        }
        Project project = getProjectResult.getProject();
        if (!StringUtils.equals((CharSequence)oldKey, (CharSequence)newKey)) {
            if (!this.checkActionPermission(user, project, ProjectAction.EDIT_PROJECT_KEY)) {
                return new ProjectService.UpdateProjectValidationResult(ErrorCollections.create((String)"projectKey", (String)i18nBean.getText(ProjectAction.EDIT_PROJECT_KEY.getErrorKey()), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
            }
            ErrorCollection errorCollection = ErrorCollections.empty();
            this.validateProjectKey(project, newKey, errorCollection, i18nBean);
            if (errorCollection.hasAnyErrors()) {
                return new ProjectService.UpdateProjectValidationResult(errorCollection);
            }
        }
        if ((validationErrors = this.validateUpdateProjectData(user, name, project, lead = this.getUserByName(leadName), url, assigneeType, avatarId)).hasAnyErrors()) {
            return new ProjectService.UpdateProjectValidationResult(validationErrors);
        }
        return new ProjectService.UpdateProjectValidationResult(ErrorCollections.empty(), name, newKey, description, leadName, url, assigneeType, avatarId, project, !StringUtils.equals((CharSequence)oldKey, (CharSequence)newKey), user);
    }

    public Project updateProject(ProjectService.UpdateProjectValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update a project with an invalid validation result.");
        }
        Project newProject = this.projectManager.updateProject(result.getOriginalProject(), result.getName(), result.getDescription(), this.keyFor(result.getLeadUsername()), result.getUrl(), result.getAssigneeType(), result.getAvatarId(), result.getKey());
        this.projectEventManager.dispatchProjectUpdated(result.getUser(), newProject, result.getOriginalProject());
        return newProject;
    }

    public ProjectService.UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(ApplicationUser user, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
        GenericValue scheme;
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"), ErrorCollection.Reason.VALIDATION_FAILED);
            return new ProjectService.UpdateProjectSchemesValidationResult(errorCollection);
        }
        if (permissionSchemeId != null && permissionSchemeId != -1L) {
            try {
                scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved.error", e.getMessage()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (notificationSchemeId != null && notificationSchemeId != -1L) {
            try {
                scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved.error", e.getMessage()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (issueSecuritySchemeId != null && issueSecuritySchemeId != -1L && (scheme = this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(issueSecuritySchemeId)) == null) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.issuesecurity.scheme.not.retrieved"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (errorCollection.hasAnyErrors()) {
            return new ProjectService.UpdateProjectSchemesValidationResult(errorCollection);
        }
        return new ProjectService.UpdateProjectSchemesValidationResult(errorCollection, permissionSchemeId, notificationSchemeId, issueSecuritySchemeId);
    }

    public void updateProjectSchemes(ProjectService.UpdateProjectSchemesValidationResult result, Project project) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update project schemes with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update project schemes with an invalid validation result.");
        }
        if (project == null) {
            throw new IllegalArgumentException("You can not update project schemes for a null project.");
        }
        Long permissionSchemeId = result.getPermissionSchemeId();
        Long notificationSchemeId = result.getNotificationSchemeId();
        Long issueSecuritySchemeId = result.getIssueSecuritySchemeId();
        try {
            Scheme currentIssueSecurityScheme;
            Scheme currentPermissionScheme;
            Scheme currentNotificationScheme = this.notificationSchemeManager.getSchemeFor(project);
            if (currentNotificationScheme == null || !currentNotificationScheme.getId().equals(notificationSchemeId)) {
                this.notificationSchemeManager.removeSchemesFromProject(project);
                if (notificationSchemeId != null && !new Long(-1L).equals(notificationSchemeId)) {
                    GenericValue scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                    this.notificationSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
                }
            }
            if (!((currentPermissionScheme = this.permissionSchemeManager.getSchemeFor(project)) != null && currentPermissionScheme.getId().equals(permissionSchemeId) || permissionSchemeId == null || new Long(-1L).equals(permissionSchemeId))) {
                this.permissionSchemeManager.removeSchemesFromProject(project);
                GenericValue scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                this.permissionSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
            }
            if ((currentIssueSecurityScheme = this.issueSecuritySchemeManager.getSchemeFor(project)) == null || !currentIssueSecurityScheme.getId().equals(issueSecuritySchemeId)) {
                if (new Long(-1L).equals(issueSecuritySchemeId)) {
                    issueSecuritySchemeId = null;
                }
                this.issueSecuritySchemeManager.setSchemeForProject(project, issueSecuritySchemeId);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public boolean isValidAllProjectData(JiraServiceContext serviceContext, ProjectCreationData projectCreationData) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nHelper = serviceContext.getI18nBean();
        this.isValidRequiredProjectData(this.getServiceContext(serviceContext.getLoggedInApplicationUser(), errorCollection), projectCreationData);
        this.validateProjectUrl(projectCreationData.getUrl(), errorCollection, i18nHelper);
        this.validateProjectAssigneeType(projectCreationData.getAssigneeType(), errorCollection, i18nHelper);
        this.validateAvatarId(projectCreationData.getAvatarId(), this.projectManager.getProjectObjByKey(projectCreationData.getKey()), errorCollection, i18nHelper);
        this.validateProjectTemplate(projectCreationData.getProjectTemplateKey(), errorCollection, i18nHelper);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection(errorCollection);
            return false;
        }
        return true;
    }

    private void validateProjectTemplate(ProjectTemplateKey projectTemplateKey, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (projectTemplateKey != null && projectTemplateKey.getKey() != null && !this.projectTemplateManager.getProjectTemplate(projectTemplateKey).isPresent()) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.invalid.project.template"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public boolean isValidRequiredProjectData(JiraServiceContext serviceContext, ProjectCreationData projectCreationData) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nBean = serviceContext.getI18nBean();
        this.validateProjectName(projectCreationData.getName(), errorCollection, i18nBean);
        this.validateProjectKey(null, projectCreationData.getKey(), errorCollection, i18nBean);
        this.validateProjectLead((Option<ApplicationUser>)Option.option((Object)projectCreationData.getLead()), errorCollection, i18nBean);
        this.validateProjectType(serviceContext.getLoggedInApplicationUser(), projectCreationData.getProjectTypeKey(), errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection(errorCollection);
            return false;
        }
        return true;
    }

    public boolean isValidProjectKey(JiraServiceContext serviceContext, String key) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nBean = serviceContext.getI18nBean();
        this.validateProjectKey(null, key, errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection(errorCollection);
            return false;
        }
        return true;
    }

    private ErrorCollection validateUpdateProjectData(ApplicationUser user, String name, Project oldProject, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        ErrorCollection errorCollection = ErrorCollections.empty();
        I18nHelper i18nHelper = this.getI18nBean(user);
        this.validateProjectNameForUpdate(name, oldProject.getKey(), errorCollection, i18nHelper);
        this.validateProjectLead((Option<ApplicationUser>)Option.option((Object)lead), errorCollection, i18nHelper);
        this.validateProjectUrl(url, errorCollection, i18nHelper);
        this.validateProjectAssigneeType(assigneeType, errorCollection, i18nHelper);
        this.validateAvatarId(avatarId, oldProject, errorCollection, i18nHelper);
        return errorCollection;
    }

    public String getProjectKeyDescription() {
        String projectKeyDescription = this.applicationProperties.getDefaultBackedString("jira.projectkey.description");
        I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
        if (TextUtils.stringSet((String)projectKeyDescription)) {
            return i18nBean.getText(projectKeyDescription);
        }
        return i18nBean.getText("admin.projects.key.description");
    }

    public ProjectService.GetProjectResult getProjectByIdForAction(ApplicationUser user, Long id, ProjectAction action) {
        Project project = this.projectManager.getProjectObj(id);
        if (project == null || !this.checkActionPermission(user, project, ProjectAction.VIEW_PROJECT)) {
            return new ProjectNotFoundResult(user, "admin.errors.project.not.found.for.id", String.valueOf(id));
        }
        if (!this.checkActionPermission(user, project, action)) {
            return new PermissionErrorResult(user, action);
        }
        return new ProjectService.GetProjectResult(project);
    }

    public ProjectService.GetProjectResult getProjectById(ApplicationUser user, Long id) {
        return this.getProjectByIdForAction(user, id, ProjectAction.VIEW_ISSUES);
    }

    public ProjectService.GetProjectResult getProjectByKey(ApplicationUser user, String key) {
        return this.getProjectByKeyForAction(user, key, ProjectAction.VIEW_ISSUES);
    }

    public ProjectService.GetProjectResult getProjectByKeyForAction(ApplicationUser user, String key, ProjectAction action) {
        Assertions.notNull((String)"action", (Object)action);
        Project project = this.projectManager.getProjectObjByKey(key);
        if (project == null || !this.checkActionPermission(user, project, ProjectAction.VIEW_PROJECT)) {
            return new ProjectNotFoundResult(user, "admin.errors.project.not.found.for.key", key);
        }
        if (!this.checkActionPermission(user, project, action)) {
            return new PermissionErrorResult(user, action);
        }
        return new ProjectService.GetProjectResult(project);
    }

    public int getMaximumNameLength() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.projectname.maxlength");
        try {
            return Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            log.error("Unable to read the MaximalProjectNameLength value '" + maxStr + "'.  Defaulting to " + 80 + ".");
            return 80;
        }
    }

    public int getMaximumKeyLength() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.projectkey.maxlength");
        try {
            return Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            log.error("Unable to read the MaximalProjectKeyLength value '" + maxStr + "'.  Defaulting to " + 10 + ".");
            return 10;
        }
    }

    public long getProjectCount() {
        return this.projectManager.getProjectCount();
    }

    public ServiceOutcome<List<Project>> getAllProjects(ApplicationUser user) {
        return this.getAllProjectsForAction(user, ProjectAction.VIEW_ISSUES);
    }

    public ServiceOutcome<List<Project>> getAllProjectsForAction(final ApplicationUser user, final ProjectAction action) {
        Iterable projects = Iterables.filter((Iterable)this.projectManager.getProjectObjects(), (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return input != null && DefaultProjectService.this.checkActionPermission(user, input, action);
            }
        });
        return new ServiceOutcomeImpl<List<Project>>(ErrorCollections.empty(), Lists.newArrayList((Iterable)projects));
    }

    public Either<Project, ErrorCollection> updateProjectType(ApplicationUser user, Project project, ProjectTypeKey newProjectType) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.checkActionPermission(user, project, ProjectAction.EDIT_PROJECT_CONFIG)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.type.update.no.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        this.validateProjectType(user, newProjectType, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            return Either.right((Object)errorCollection);
        }
        return this.executeUnderClusterLock(this.getLockNameFor(project), () -> {
            Project updatedProject = this.projectManager.updateProjectType(user, project, newProjectType);
            return this.notifyProjectTypeUpdated(user, updatedProject, project.getProjectTypeKey(), newProjectType);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<Project, ErrorCollection> executeUnderClusterLock(String lockName, Supplier<Either<Project, ErrorCollection>> supplier) {
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        lock.lock();
        try {
            Either<Project, ErrorCollection> either = supplier.get();
            return either;
        }
        finally {
            lock.unlock();
        }
    }

    private String getLockNameFor(Project project) {
        return DefaultProjectService.class.getName() + ".updateProjectType." + project.getId();
    }

    private Either<Project, ErrorCollection> notifyProjectTypeUpdated(ApplicationUser user, Project project, ProjectTypeKey oldProjectType, ProjectTypeKey newProjectType) {
        boolean notificationWasSuccessful = this.projectTypeUpdatedNotifier.notifyAllHandlers(project, oldProjectType, newProjectType);
        if (!notificationWasSuccessful) {
            this.projectManager.updateProjectType(user, project, oldProjectType);
            return Either.right((Object)new SimpleErrorCollection("admin.errors.project.type.update.error", ErrorCollection.Reason.SERVER_ERROR));
        }
        return Either.left((Object)project);
    }

    private void validateProjectAssigneeType(Long assigneeType, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (assigneeType != null && !ProjectAssigneeTypes.isValidType((Long)assigneeType)) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.default.assignee"));
        }
    }

    private void validateAvatarId(Long avatarId, Project oldProject, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (avatarId == null) {
            return;
        }
        Avatar avatar = this.avatarManager.getById(avatarId);
        if (avatar == null) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.avatar.does.not.exist", (Object)avatarId), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (!avatar.isSystemAvatar() && !oldProject.getId().toString().equals(avatar.getOwner())) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.avatar"));
        }
    }

    private void validateProjectUrl(String url, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (TextUtils.stringSet((String)url)) {
            if (url.length() > 255) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.project.url.too.long"));
            } else if (!TextUtils.verifyUrl((String)url)) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.url.specified.is.not.valid"));
            }
        }
    }

    private void validateProjectType(ApplicationUser user, ProjectTypeKey projectType, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!this.projectTypeValidator.isValid(user, projectType)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.invalid.project.type"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void validateProjectKey(Project oldProject, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!this.isProjectKeyValid(key)) {
            String projectKeyWarning = this.applicationProperties.getDefaultBackedString("jira.projectkey.warning");
            if (TextUtils.stringSet((String)projectKeyWarning)) {
                errorCollection.addError("projectKey", i18nBean.getText(projectKeyWarning));
            } else {
                errorCollection.addError("projectKey", i18nBean.getText("admin.errors.must.specify.unique.project.key"));
            }
        } else if (this.isReservedKeyword(key)) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.keyword.invalid"));
        } else if (key.length() > this.getMaximumKeyLength()) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.key.too.long", (Object)this.getMaximumKeyLength()));
        } else {
            Project projectByNewKey = this.projectManager.getProjectObjByKey(key);
            if (projectByNewKey != null) {
                if (oldProject == null || !oldProject.getId().equals(projectByNewKey.getId())) {
                    errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.with.that.key.already.exists", projectByNewKey.getName()));
                }
            } else {
                Long projectId = this.projectKeyStore.getProjectId(key);
                if (projectId != null) {
                    errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.with.that.key.already.exists.unknown"));
                }
            }
        }
    }

    private void validateProjectLead(Option<ApplicationUser> lead, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (lead.isEmpty()) {
            errorCollection.addError("projectLead", i18nBean.getText("admin.errors.must.specify.project.lead"));
        }
    }

    private void validateProjectName(String name, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.projectNameValidator.validateForCreate(name, errorCollection, i18nBean);
    }

    private void validateProjectNameForUpdate(String name, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.projectNameValidator.validateForUpdate(name, key, errorCollection, i18nBean);
    }

    protected final I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    boolean isReservedKeyword(String key) {
        return JiraKeyUtils.isReservedKeyword((String)key);
    }

    boolean isProjectKeyValid(String key) {
        return JiraKeyUtils.validProjectKey((String)key);
    }

    boolean checkActionPermission(ApplicationUser user, Project project, ProjectAction action) {
        return action.hasPermission(this.permissionManager, user, project);
    }

    protected final ErrorCollection makeErrorCollection(ApplicationUser user, String i18nKey, ErrorCollection.Reason reason, String ... params) {
        ErrorCollection errors = ErrorCollections.empty();
        I18nHelper i18nBean = this.getI18nBean(user);
        errors.addErrorMessage(i18nBean.getText(i18nKey, (Object)params), reason);
        if (reason == ErrorCollection.Reason.FORBIDDEN && user == null) {
            errors.addErrorMessage(i18nBean.getText("common.forms.ajax.unauthorised.alert"), ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        return errors;
    }

    private Long effectiveAssigneeType(Long requestedAssigneeType) {
        if (requestedAssigneeType != null) {
            return requestedAssigneeType;
        }
        if (this.applicationProperties.getOption("jira.option.allowunassigned")) {
            return 3L;
        }
        return 2L;
    }

    private String keyFor(String username) {
        return ApplicationUsers.getKeyFor(this.getUserByName(username));
    }

    private String nameFor(ApplicationUser user) {
        return user != null ? user.getUsername() : null;
    }

    private ApplicationUser getUserByName(String leadName) {
        return this.userManager.getUserByName(leadName);
    }

    protected class PermissionErrorResult
    extends ProjectService.GetProjectResult {
        protected PermissionErrorResult(ApplicationUser user, ProjectAction action) {
            super(DefaultProjectService.this.makeErrorCollection(user, action.getErrorKey(), ErrorCollection.Reason.FORBIDDEN, new String[0]));
        }
    }

    protected class ProjectNotFoundResult
    extends ProjectService.GetProjectResult {
        protected ProjectNotFoundResult(ApplicationUser user, String i18nKey, String ... params) {
            super(DefaultProjectService.this.makeErrorCollection(user, i18nKey, ErrorCollection.Reason.NOT_FOUND, params));
        }
    }
}

